/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ExampleMetadata
extends ReadOnlyConnectorMetadata {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleMetadata(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.exampleClient = (ExampleClient)Preconditions.checkNotNull((Object)exampleClient, (Object)"client is null");
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof ExampleTableHandle && ((ExampleTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public List<String> listSchemaNames() {
        return ImmutableList.copyOf(this.exampleClient.getSchemaNames());
    }

    public ExampleTableHandle getTableHandle(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ExampleTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle table) {
        Preconditions.checkArgument((boolean)(table instanceof ExampleTableHandle), (Object)"tableHandle is not an instance of ExampleTableHandle");
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)table;
        Preconditions.checkArgument((boolean)exampleTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        SchemaTableName tableName = new SchemaTableName(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        Object schemaNames = schemaNameOrNull != null ? ImmutableSet.of((Object)schemaNameOrNull) : this.exampleClient.getSchemaNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator i$ = schemaNames.iterator();
        while (i$.hasNext()) {
            String schemaName = (String)i$.next();
            for (String tableName : this.exampleClient.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        return this.getColumnHandles(tableHandle).get(columnName);
    }

    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        return null;
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof ExampleTableHandle), (Object)"tableHandle is not an instance of ExampleTableHandle");
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)exampleTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(exampleTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : table.getColumnsMetadata()) {
            columnHandles.put((Object)columnMetadata.getName(), (Object)new ExampleColumnHandle(this.connectorId, columnMetadata));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof ExampleTableHandle), (Object)"tableHandle is not an instance of ExampleTableHandle");
        Preconditions.checkArgument((boolean)((ExampleTableHandle)tableHandle).getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        Preconditions.checkArgument((boolean)(columnHandle instanceof ExampleColumnHandle), (Object)"columnHandle is not an instance of ExampleColumnHandle");
        return ((ExampleColumnHandle)columnHandle).getColumnMetadata();
    }
}

