/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class ExampleSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final URI uri;
    private final List<HostAddress> addresses;

    @JsonCreator
    public ExampleSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="uri") URI uri) {
        this.schemaName = Objects.requireNonNull(schemaName, "schema name is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.addresses = ImmutableList.of((Object)HostAddress.fromUri((URI)uri));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public URI getUri() {
        return this.uri;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

