/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.AlignedTablePrinter;
import com.facebook.presto.cli.OutputPrinter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class VerticalRecordPrinter
implements OutputPrinter {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final List<String> fieldNames;
    private final int namesWidth;
    private final Writer writer;
    private long rowCount;

    public VerticalRecordPrinter(List<String> fieldNames, Writer writer) {
        this.fieldNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fieldNames, (Object)"fieldNames is null")));
        this.namesWidth = VerticalRecordPrinter.maxWidth(fieldNames);
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer, (Object)"writer is null");
    }

    @Override
    public void finish() throws IOException {
        if (this.rowCount == 0L) {
            this.writer.append("(no rows)\n");
        }
        this.writer.flush();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        int valuesWidth = 0;
        for (List<?> row : rows) {
            for (Object o : row) {
                valuesWidth = Math.max(valuesWidth, AlignedTablePrinter.maxLineLength(AlignedTablePrinter.formatValue(o)));
            }
        }
        for (List<?> row : rows) {
            ++this.rowCount;
            String header = "-[ RECORD " + this.rowCount + " ]";
            if (this.namesWidth + 1 >= header.length()) {
                header = header + Strings.repeat((String)"-", (int)(this.namesWidth + 1 - header.length())) + "+";
            }
            header = header + Strings.repeat((String)"-", (int)Math.max(0, this.namesWidth + valuesWidth + 3 - header.length()));
            this.writer.append(header).append('\n');
            for (int i = 0; i < row.size(); ++i) {
                String name = this.fieldNames.get(i);
                String column = AlignedTablePrinter.formatValue(row.get(i));
                for (String line : LINE_SPLITTER.split((CharSequence)column)) {
                    this.writer.append(name).append(Strings.repeat((String)" ", (int)(this.namesWidth - name.length()))).append(" | ").append(AlignedTablePrinter.formatValue(line)).append("\n");
                    name = Strings.repeat((String)" ", (int)name.length());
                }
            }
        }
    }

    private static int maxWidth(Iterable<String> strings) {
        int n = 0;
        for (String s : strings) {
            n = Math.max(n, s.length());
        }
        return n;
    }
}

