/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import au.com.bytecode.opencsv.CSVWriter;
import com.facebook.presto.cli.AlignedTablePrinter;
import com.facebook.presto.cli.OutputPrinter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;

public class CsvPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final CSVWriter writer;
    private boolean needHeader;

    public CsvPrinter(List<String> fieldNames, Writer writer, boolean header) {
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(writer, "writer is null");
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.writer = new CSVWriter(writer);
        this.needHeader = header;
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        if (this.needHeader) {
            this.needHeader = false;
            this.writer.writeNext(CsvPrinter.toStrings(this.fieldNames));
        }
        for (List<?> row : rows) {
            this.writer.writeNext(CsvPrinter.toStrings(row));
            this.checkError();
        }
    }

    @Override
    public void finish() throws IOException {
        this.printRows((List<List<?>>)ImmutableList.of(), true);
        this.writer.flush();
        this.checkError();
    }

    private void checkError() throws IOException {
        if (this.writer.checkError()) {
            throw new IOException("error writing to output");
        }
    }

    private static String[] toStrings(List<?> values) {
        String[] array = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            array[i] = CsvPrinter.formatValue(values.get(i));
        }
        return array;
    }

    static String formatValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof byte[]) {
            return AlignedTablePrinter.formatHexDump((byte[])o);
        }
        return o.toString();
    }
}

