/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.AlignedTablePrinter;
import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.cli.ConsolePrinter;
import com.facebook.presto.cli.CsvPrinter;
import com.facebook.presto.cli.NullPrinter;
import com.facebook.presto.cli.OutputHandler;
import com.facebook.presto.cli.OutputPrinter;
import com.facebook.presto.cli.Pager;
import com.facebook.presto.cli.QueryAbortedException;
import com.facebook.presto.cli.StatusPrinter;
import com.facebook.presto.cli.TsvPrinter;
import com.facebook.presto.cli.VerticalRecordPrinter;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.ErrorLocation;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.jansi.Ansi;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Query
implements Closeable {
    private static final Logger log = Logger.get(Query.class);
    private static final Signal SIGINT = new Signal("INT");
    private final AtomicBoolean ignoreUserInterrupt = new AtomicBoolean();
    private final AtomicBoolean userAbortedQuery = new AtomicBoolean();
    private final StatementClient client;

    public Query(StatementClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public Map<String, String> getSetSessionProperties() {
        return this.client.getSetSessionProperties();
    }

    public Set<String> getResetSessionProperties() {
        return this.client.getResetSessionProperties();
    }

    public String getStartedTransactionId() {
        return this.client.getStartedtransactionId();
    }

    public boolean isClearTransactionId() {
        return this.client.isClearTransactionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOutput(PrintStream out, ClientOptions.OutputFormat outputFormat, boolean interactive) {
        Thread clientThread = Thread.currentThread();
        SignalHandler oldHandler = Signal.handle(SIGINT, signal -> {
            if (this.ignoreUserInterrupt.get() || this.client.isClosed()) {
                return;
            }
            this.userAbortedQuery.set(true);
            this.client.close();
            clientThread.interrupt();
        });
        try {
            this.renderQueryOutput(out, outputFormat, interactive);
        }
        finally {
            Signal.handle(SIGINT, oldHandler);
            Thread.interrupted();
        }
    }

    private void renderQueryOutput(PrintStream out, ClientOptions.OutputFormat outputFormat, boolean interactive) {
        PrintStream errorChannel;
        StatusPrinter statusPrinter = null;
        PrintStream printStream = errorChannel = interactive ? out : System.err;
        if (interactive) {
            statusPrinter = new StatusPrinter(this.client, out);
            statusPrinter.printInitialStatusUpdates();
        } else {
            this.waitForData();
        }
        if (!(this.client.isFailed() || this.client.isGone() || this.client.isClosed())) {
            QueryResults results;
            QueryResults queryResults = results = this.client.isValid() ? this.client.current() : this.client.finalResults();
            if (results.getUpdateType() != null) {
                this.renderUpdate(out, results);
            } else {
                if (results.getColumns() == null) {
                    errorChannel.printf("Query %s has no columns\n", results.getId());
                    return;
                }
                this.renderResults(out, outputFormat, interactive, results.getColumns());
            }
        }
        if (statusPrinter != null) {
            statusPrinter.printFinalInfo();
        }
        if (this.client.isClosed()) {
            errorChannel.println("Query aborted by user");
        } else if (this.client.isGone()) {
            errorChannel.println("Query is gone (server restarted?)");
        } else if (this.client.isFailed()) {
            this.renderFailure(errorChannel);
        }
    }

    private void waitForData() {
        while (this.client.isValid() && this.client.current().getData() == null) {
            this.client.advance();
        }
    }

    private void renderUpdate(PrintStream out, QueryResults results) {
        String status = results.getUpdateType();
        if (results.getUpdateCount() != null) {
            long count = results.getUpdateCount();
            status = status + String.format(": %s row%s", count, count != 1L ? "s" : "");
        }
        out.println(status);
        this.discardResults();
    }

    private void discardResults() {
        try (OutputHandler handler = new OutputHandler(new NullPrinter());){
            handler.processRows(this.client);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void renderResults(PrintStream out, ClientOptions.OutputFormat outputFormat, boolean interactive, List<Column> columns) {
        try {
            this.doRenderResults(out, outputFormat, interactive, columns);
        }
        catch (QueryAbortedException e) {
            System.out.println("(query aborted by user)");
            this.client.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void doRenderResults(PrintStream out, ClientOptions.OutputFormat format, boolean interactive, List<Column> columns) throws IOException {
        List fieldNames = Lists.transform(columns, Column::getName);
        if (interactive) {
            this.pageOutput(format, fieldNames);
        } else {
            this.sendOutput(out, format, fieldNames);
        }
    }

    private void pageOutput(ClientOptions.OutputFormat format, List<String> fieldNames) throws IOException {
        try (Pager pager = Pager.create();
             ThreadInterruptor clientThread = new ThreadInterruptor();
             Writer writer = Query.createWriter(pager);
             OutputHandler handler = Query.createOutputHandler(format, writer, fieldNames);){
            if (!pager.isNullPager()) {
                this.ignoreUserInterrupt.set(true);
                pager.getFinishFuture().thenRun(() -> {
                    this.userAbortedQuery.set(true);
                    this.ignoreUserInterrupt.set(false);
                    clientThread.interrupt();
                });
            }
            handler.processRows(this.client);
        }
        catch (IOException | RuntimeException e) {
            if (this.userAbortedQuery.get() && !(e instanceof QueryAbortedException)) {
                throw new QueryAbortedException(e);
            }
            throw e;
        }
    }

    private void sendOutput(PrintStream out, ClientOptions.OutputFormat format, List<String> fieldNames) throws IOException {
        try (OutputHandler handler = Query.createOutputHandler(format, Query.createWriter(out), fieldNames);){
            handler.processRows(this.client);
        }
    }

    private static OutputHandler createOutputHandler(ClientOptions.OutputFormat format, Writer writer, List<String> fieldNames) {
        return new OutputHandler(Query.createOutputPrinter(format, writer, fieldNames));
    }

    private static OutputPrinter createOutputPrinter(ClientOptions.OutputFormat format, Writer writer, List<String> fieldNames) {
        switch (format) {
            case ALIGNED: {
                return new AlignedTablePrinter(fieldNames, writer);
            }
            case VERTICAL: {
                return new VerticalRecordPrinter(fieldNames, writer);
            }
            case CSV: {
                return new CsvPrinter(fieldNames, writer, false);
            }
            case CSV_HEADER: {
                return new CsvPrinter(fieldNames, writer, true);
            }
            case TSV: {
                return new TsvPrinter(fieldNames, writer, false);
            }
            case TSV_HEADER: {
                return new TsvPrinter(fieldNames, writer, true);
            }
            case NULL: {
                return new NullPrinter();
            }
        }
        throw new RuntimeException((Object)((Object)format) + " not supported");
    }

    private static Writer createWriter(OutputStream out) {
        return new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public void renderFailure(PrintStream out) {
        QueryResults results = this.client.finalResults();
        QueryError error = results.getError();
        Preconditions.checkState((error != null ? 1 : 0) != 0);
        out.printf("Query %s failed: %s%n", results.getId(), error.getMessage());
        if (this.client.isDebug() && error.getFailureInfo() != null) {
            error.getFailureInfo().toException().printStackTrace(out);
        }
        if (error.getErrorLocation() != null) {
            Query.renderErrorLocation(this.client.getQuery(), error.getErrorLocation(), out);
        }
        out.println();
    }

    private static void renderErrorLocation(String query, ErrorLocation location, PrintStream out) {
        ImmutableList lines = ImmutableList.copyOf(Splitter.on((char)'\n').split((CharSequence)query).iterator());
        String errorLine = (String)lines.get(location.getLineNumber() - 1);
        String good = errorLine.substring(0, location.getColumnNumber() - 1);
        String bad = errorLine.substring(location.getColumnNumber() - 1);
        if (location.getLineNumber() == lines.size() && bad.trim().isEmpty()) {
            bad = " <EOF>";
        }
        if (ConsolePrinter.REAL_TERMINAL) {
            int i;
            Ansi ansi = Ansi.ansi();
            ansi.fg(Ansi.Color.CYAN);
            for (i = 1; i < location.getLineNumber(); ++i) {
                ansi.a((String)lines.get(i - 1)).newline();
            }
            ansi.a(good);
            ansi.fg(Ansi.Color.RED);
            ansi.a(bad).newline();
            for (i = location.getLineNumber(); i < lines.size(); ++i) {
                ansi.a((String)lines.get(i)).newline();
            }
            ansi.reset();
            out.print(ansi);
        } else {
            String prefix = String.format("LINE %s: ", location.getLineNumber());
            String padding = Strings.repeat((String)" ", (int)(prefix.length() + (location.getColumnNumber() - 1)));
            out.println(prefix + errorLine);
            out.println(padding + "^");
        }
    }

    private static class ThreadInterruptor
    implements Closeable {
        private final Thread thread = Thread.currentThread();
        private final AtomicBoolean processing = new AtomicBoolean(true);

        private ThreadInterruptor() {
        }

        public synchronized void interrupt() {
            if (this.processing.get()) {
                this.thread.interrupt();
            }
        }

        @Override
        public synchronized void close() {
            this.processing.set(false);
        }
    }
}

