/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.QueryAbortedException;
import com.google.common.collect.ImmutableList;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;

public class Pager
extends FilterOutputStream {
    public static final String ENV_PAGER = "PRESTO_PAGER";
    public static final List<String> LESS = ImmutableList.of((Object)"less", (Object)"-FXRSn");
    private final Process process;

    private Pager(OutputStream out, @Nullable Process process) {
        super(out);
        this.process = process;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            throw Pager.propagateIOException(e);
        }
        finally {
            if (this.process != null) {
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.process.destroy();
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            super.write(b);
        }
        catch (IOException e) {
            throw Pager.propagateIOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            super.write(b, off, len);
        }
        catch (IOException e) {
            throw Pager.propagateIOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            super.flush();
        }
        catch (IOException e) {
            throw Pager.propagateIOException(e);
        }
    }

    private static IOException propagateIOException(IOException e) throws IOException {
        if ("Broken pipe".equals(e.getMessage()) || "Stream closed".equals(e.getMessage())) {
            throw new QueryAbortedException(e);
        }
        throw e;
    }

    public static Pager create() {
        String pager = System.getenv(ENV_PAGER);
        if (pager == null) {
            return Pager.create(LESS);
        }
        if ((pager = pager.trim()).isEmpty()) {
            return Pager.createNullPager();
        }
        return Pager.create((List<String>)ImmutableList.of((Object)"/bin/sh", (Object)"-c", (Object)pager));
    }

    public static Pager create(List<String> command) {
        try {
            Process process = new ProcessBuilder(new String[0]).command(command).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            return new Pager(process.getOutputStream(), process);
        }
        catch (IOException e) {
            System.err.println("ERROR: failed to open pager: " + e.getMessage());
            return Pager.createNullPager();
        }
    }

    private static Pager createNullPager() {
        return new Pager(Pager.uncloseableOutputStream(System.out), null);
    }

    private static OutputStream uncloseableOutputStream(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };
    }
}

