/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.debug.LocalVariableNode;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodGenerationContext {
    private final MethodVisitor methodVisitor;
    private final Set<Scope> allEnteredScopes = new LinkedHashSet<Scope>();
    private final Deque<ScopeContext> scopes = new ArrayDeque<ScopeContext>();
    private final Map<Variable, Integer> variableSlots = new HashMap<Variable, Integer>();
    private int nextSlot;
    private int currentLineNumber = -1;

    public MethodGenerationContext(MethodVisitor methodVisitor) {
        this.methodVisitor = Objects.requireNonNull(methodVisitor, "methodVisitor is null");
    }

    public void enterScope(Scope scope) {
        Objects.requireNonNull(scope, "scope is null");
        Preconditions.checkArgument((!this.allEnteredScopes.contains(scope) ? 1 : 0) != 0, (Object)"scope has already been entered");
        this.allEnteredScopes.add(scope);
        ScopeContext scopeContext = new ScopeContext(scope);
        this.scopes.addLast(scopeContext);
        for (Variable variable : scopeContext.getVariables()) {
            Preconditions.checkArgument((!"this".equals(variable.getName()) || this.nextSlot == 0 ? 1 : 0) != 0, (Object)"The 'this' variable must be in slot 0");
            this.variableSlots.put(variable, this.nextSlot);
            this.nextSlot += Type.getType((String)variable.getType().getType()).getSize();
        }
        scopeContext.getStartLabel().accept(this.methodVisitor, this);
    }

    public void exitScope(Scope scope) {
        Preconditions.checkArgument((boolean)this.allEnteredScopes.contains(scope), (Object)"scope has not been entered");
        Preconditions.checkArgument((!this.scopes.isEmpty() && scope == this.scopes.peekLast().getScope() ? 1 : 0) != 0, (Object)"Scope is not top of the stack");
        ScopeContext scopeContext = this.scopes.removeLast();
        scopeContext.getEndLabel().accept(this.methodVisitor, this);
        for (Variable variable : scopeContext.getVariables()) {
            new LocalVariableNode(variable, scopeContext.getStartLabel(), scopeContext.getEndLabel()).accept(this.methodVisitor, this);
        }
        this.variableSlots.keySet().removeAll((Collection<?>)scopeContext.getVariables());
    }

    public int getVariableSlot(Variable variable) {
        Integer slot = this.variableSlots.get(variable);
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (String)"Variable '%s' has not been assigned a slot", (Object)variable);
        return slot;
    }

    public boolean updateLineNumber(int lineNumber) {
        if (lineNumber == this.currentLineNumber) {
            return false;
        }
        this.currentLineNumber = lineNumber;
        return true;
    }

    private final class ScopeContext {
        private final Scope scope;
        private final ImmutableList<Variable> variables;
        private final LabelNode startLabel = new LabelNode("VariableStart");
        private final LabelNode endLabel = new LabelNode("VariableEnd");

        public ScopeContext(Scope scope) {
            this.scope = scope;
            this.variables = ImmutableList.copyOf(scope.getVariables());
        }

        public Scope getScope() {
            return this.scope;
        }

        public ImmutableList<Variable> getVariables() {
            return this.variables;
        }

        public LabelNode getStartLabel() {
            return this.startLabel;
        }

        public LabelNode getEndLabel() {
            return this.endLabel;
        }
    }
}

