/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.ArrayOpCode;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.TypeInstruction;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class NewArrayBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression length;
    private final ParameterizedType elementType;
    @Nullable
    private final List<BytecodeExpression> elements;

    public NewArrayBytecodeExpression(ParameterizedType type, int length) {
        this(type, BytecodeExpressions.constantInt(length));
    }

    public NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length) {
        super(type);
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getArrayComponentType() != null ? 1 : 0) != 0, (String)"type %s must be array type", (Object)type);
        this.elementType = type.getArrayComponentType();
        this.length = Objects.requireNonNull(length, "length is null");
        this.elements = null;
    }

    public NewArrayBytecodeExpression(ParameterizedType type, List<BytecodeExpression> elements) {
        super(type);
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getArrayComponentType() != null ? 1 : 0) != 0, (String)"type %s must be array type", (Object)type);
        Objects.requireNonNull(elements, "elements is null");
        this.elementType = type.getArrayComponentType();
        for (int i = 0; i < elements.size(); ++i) {
            BytecodeExpression element = elements.get(i);
            ParameterizedType elementType = element.getType();
            Preconditions.checkArgument((boolean)elementType.equals(this.elementType), (String)"element %s must be %s type, but is %s", (Object)i, (Object)this.elementType, (Object)elementType);
        }
        this.length = BytecodeExpressions.constantInt(elements.size());
        this.elements = elements;
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock bytecodeBlock = this.elementType.isPrimitive() ? new BytecodeBlock().append(this.length).append(TypeInstruction.newPrimitiveArray(this.elementType)) : new BytecodeBlock().append(this.length).append(TypeInstruction.newObjectArray(this.elementType));
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                BytecodeExpression element = this.elements.get(i);
                bytecodeBlock.dup().append(BytecodeExpressions.constantInt(i)).append(element).append(ArrayOpCode.getArrayOpCode(this.elementType).getStore());
            }
        }
        return bytecodeBlock;
    }

    @Override
    protected String formatOneLine() {
        if (this.elements == null) {
            return "new " + this.elementType.getSimpleName() + "[" + this.length + "]";
        }
        return "new " + this.elementType.getSimpleName() + "[] {" + Joiner.on((String)", ").join(this.elements) + "}";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

