/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassInfoLoader;
import com.facebook.presto.bytecode.CompilationException;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.SmartClassWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.reflect.Reflection;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public final class CompilerUtils {
    private static final Logger log = Logger.get(CompilerUtils.class);
    private static final boolean ADD_FAKE_LINE_NUMBER = false;
    private static final boolean DUMP_BYTE_CODE_TREE = false;
    private static final boolean DUMP_BYTE_CODE_RAW = false;
    private static final boolean RUN_ASM_VERIFIER = false;
    private static final AtomicReference<String> DUMP_CLASS_FILES_TO = new AtomicReference();
    private static final AtomicLong CLASS_ID = new AtomicLong();

    private CompilerUtils() {
    }

    public static ParameterizedType makeClassName(String baseName) {
        String className = baseName + "_" + CLASS_ID.incrementAndGet();
        String javaClassName = CompilerUtils.toJavaIdentifierString(className);
        return ParameterizedType.typeFromJavaClassName("com.facebook.presto.$gen." + javaClassName);
    }

    public static String toJavaIdentifierString(String className) {
        int[] codePoints = className.codePoints().map(c -> Character.isJavaIdentifierPart(c) ? c : 95).toArray();
        return new String(codePoints, 0, codePoints.length);
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        log.debug("Defining class: %s", new Object[]{classDefinition.getName()});
        Class<?> clazz = CompilerUtils.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition), classLoader).values().iterator().next();
        return clazz.asSubclass(superType);
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, Map<Long, MethodHandle> callSiteBindings, ClassLoader parentClassLoader) {
        Class<T> clazz = CompilerUtils.defineClass(classDefinition, superType, new DynamicClassLoader(parentClassLoader, callSiteBindings));
        return clazz.asSubclass(superType);
    }

    private static Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions, DynamicClassLoader classLoader) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, classLoader);
        LinkedHashMap<String, byte[]> bytecodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            SmartClassWriter smartClassWriter = new SmartClassWriter(classInfoLoader);
            try {
                classDefinition.visit((ClassVisitor)smartClassWriter);
            }
            catch (IndexOutOfBoundsException | NegativeArraySizeException runtimeException) {
                Textifier printer = new Textifier();
                StringWriter stringWriter = new StringWriter();
                TraceClassVisitor tcv = new TraceClassVisitor(null, (Printer)printer, new PrintWriter(stringWriter));
                classDefinition.visit((ClassVisitor)tcv);
                throw new IllegalArgumentException("An error occurred while processing classDefinition:" + System.lineSeparator() + stringWriter.toString(), runtimeException);
            }
            try {
                byte[] byArray = smartClassWriter.toByteArray();
                bytecodes.put(classDefinition.getType().getJavaClassName(), byArray);
            }
            catch (RuntimeException runtimeException) {
                throw new CompilationException("Error compiling class " + classDefinition.getName(), runtimeException);
            }
        }
        String dumpClassPath = DUMP_CLASS_FILES_TO.get();
        if (dumpClassPath != null) {
            for (Map.Entry entry : bytecodes.entrySet()) {
                File file = new File(dumpClassPath, ParameterizedType.typeFromJavaClassName((String)entry.getKey()).getClassName() + ".class");
                try {
                    log.debug("ClassFile: " + file.getAbsolutePath());
                    Files.createParentDirs((File)file);
                    Files.write((byte[])((byte[])entry.getValue()), (File)file);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to write generated class file to: %s" + file.getAbsolutePath());
                }
            }
        }
        Map<String, Class<?>> map = classLoader.defineClasses(bytecodes);
        try {
            for (Class<?> clazz : map.values()) {
                Reflection.initialize((Class[])new Class[]{clazz});
            }
        }
        catch (VerifyError verifyError) {
            throw new RuntimeException(verifyError);
        }
        return map;
    }
}

