/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPASAdvertiserPartnershipRecommendation
extends APINode {
    @SerializedName(value="advertiser_business_id")
    private String mAdvertiserBusinessId = null;
    @SerializedName(value="brand_business_id")
    private String mBrandBusinessId = null;
    @SerializedName(value="brands")
    private List<String> mBrands = null;
    @SerializedName(value="countries")
    private List<String> mCountries = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="merchant_business_id")
    private String mMerchantBusinessId = null;
    @SerializedName(value="merchant_categories")
    private List<String> mMerchantCategories = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="status_reason")
    private String mStatusReason = null;
    protected static Gson gson = null;

    CPASAdvertiserPartnershipRecommendation() {
    }

    public CPASAdvertiserPartnershipRecommendation(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CPASAdvertiserPartnershipRecommendation(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CPASAdvertiserPartnershipRecommendation fetch() throws APIException {
        CPASAdvertiserPartnershipRecommendation newInstance = CPASAdvertiserPartnershipRecommendation.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CPASAdvertiserPartnershipRecommendation fetchById(Long id, APIContext context) throws APIException {
        return CPASAdvertiserPartnershipRecommendation.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CPASAdvertiserPartnershipRecommendation> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CPASAdvertiserPartnershipRecommendation.fetchByIdAsync(id.toString(), context);
    }

    public static CPASAdvertiserPartnershipRecommendation fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CPASAdvertiserPartnershipRecommendation> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CPASAdvertiserPartnershipRecommendation> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CPASAdvertiserPartnershipRecommendation>(context, "", "/", "GET", CPASAdvertiserPartnershipRecommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CPASAdvertiserPartnershipRecommendation>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CPASAdvertiserPartnershipRecommendation>(context, "", "/", "GET", CPASAdvertiserPartnershipRecommendation.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASAdvertiserPartnershipRecommendation loadJSON(String json, APIContext context, String header) {
        CPASAdvertiserPartnershipRecommendation cpasAdvertiserPartnershipRecommendation = (CPASAdvertiserPartnershipRecommendation)CPASAdvertiserPartnershipRecommendation.getGson().fromJson(json, CPASAdvertiserPartnershipRecommendation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasAdvertiserPartnershipRecommendation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasAdvertiserPartnershipRecommendation.context = context;
        cpasAdvertiserPartnershipRecommendation.rawValue = json;
        cpasAdvertiserPartnershipRecommendation.header = header;
        return cpasAdvertiserPartnershipRecommendation;
    }

    public static APINodeList<CPASAdvertiserPartnershipRecommendation> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASAdvertiserPartnershipRecommendation> cpasAdvertiserPartnershipRecommendations = new APINodeList<CPASAdvertiserPartnershipRecommendation>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasAdvertiserPartnershipRecommendations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasAdvertiserPartnershipRecommendations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasAdvertiserPartnershipRecommendations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasAdvertiserPartnershipRecommendations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasAdvertiserPartnershipRecommendations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasAdvertiserPartnershipRecommendations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasAdvertiserPartnershipRecommendations;
                }
                cpasAdvertiserPartnershipRecommendations.clear();
                cpasAdvertiserPartnershipRecommendations.add(CPASAdvertiserPartnershipRecommendation.loadJSON(json, context, header));
                return cpasAdvertiserPartnershipRecommendations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASAdvertiserPartnershipRecommendation.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdvertiserBusinessId() {
        return this.mAdvertiserBusinessId;
    }

    public String getFieldBrandBusinessId() {
        return this.mBrandBusinessId;
    }

    public List<String> getFieldBrands() {
        return this.mBrands;
    }

    public List<String> getFieldCountries() {
        return this.mCountries;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMerchantBusinessId() {
        return this.mMerchantBusinessId;
    }

    public List<String> getFieldMerchantCategories() {
        return this.mMerchantCategories;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStatusReason() {
        return this.mStatusReason;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASAdvertiserPartnershipRecommendation copyFrom(CPASAdvertiserPartnershipRecommendation instance) {
        this.mAdvertiserBusinessId = instance.mAdvertiserBusinessId;
        this.mBrandBusinessId = instance.mBrandBusinessId;
        this.mBrands = instance.mBrands;
        this.mCountries = instance.mCountries;
        this.mId = instance.mId;
        this.mMerchantBusinessId = instance.mMerchantBusinessId;
        this.mMerchantCategories = instance.mMerchantCategories;
        this.mStatus = instance.mStatus;
        this.mStatusReason = instance.mStatusReason;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASAdvertiserPartnershipRecommendation> getParser() {
        return new APIRequest.ResponseParser<CPASAdvertiserPartnershipRecommendation>(){

            @Override
            public APINodeList<CPASAdvertiserPartnershipRecommendation> parseResponse(String response, APIContext context, APIRequest<CPASAdvertiserPartnershipRecommendation> request, String header) throws APIException.MalformedResponseException {
                return CPASAdvertiserPartnershipRecommendation.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CPASAdvertiserPartnershipRecommendation> {
        CPASAdvertiserPartnershipRecommendation lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"advertiser_business_id", "brand_business_id", "brands", "countries", "id", "merchant_business_id", "merchant_categories", "status", "status_reason"};

        @Override
        public CPASAdvertiserPartnershipRecommendation getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASAdvertiserPartnershipRecommendation parseResponse(String response, String header) throws APIException {
            return CPASAdvertiserPartnershipRecommendation.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASAdvertiserPartnershipRecommendation execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASAdvertiserPartnershipRecommendation execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASAdvertiserPartnershipRecommendation> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASAdvertiserPartnershipRecommendation> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASAdvertiserPartnershipRecommendation>(){

                public CPASAdvertiserPartnershipRecommendation apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdvertiserBusinessIdField() {
            return this.requestAdvertiserBusinessIdField(true);
        }

        public APIRequestGet requestAdvertiserBusinessIdField(boolean value) {
            this.requestField("advertiser_business_id", value);
            return this;
        }

        public APIRequestGet requestBrandBusinessIdField() {
            return this.requestBrandBusinessIdField(true);
        }

        public APIRequestGet requestBrandBusinessIdField(boolean value) {
            this.requestField("brand_business_id", value);
            return this;
        }

        public APIRequestGet requestBrandsField() {
            return this.requestBrandsField(true);
        }

        public APIRequestGet requestBrandsField(boolean value) {
            this.requestField("brands", value);
            return this;
        }

        public APIRequestGet requestCountriesField() {
            return this.requestCountriesField(true);
        }

        public APIRequestGet requestCountriesField(boolean value) {
            this.requestField("countries", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMerchantBusinessIdField() {
            return this.requestMerchantBusinessIdField(true);
        }

        public APIRequestGet requestMerchantBusinessIdField(boolean value) {
            this.requestField("merchant_business_id", value);
            return this;
        }

        public APIRequestGet requestMerchantCategoriesField() {
            return this.requestMerchantCategoriesField(true);
        }

        public APIRequestGet requestMerchantCategoriesField(boolean value) {
            this.requestField("merchant_categories", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStatusReasonField() {
            return this.requestStatusReasonField(true);
        }

        public APIRequestGet requestStatusReasonField(boolean value) {
            this.requestField("status_reason", value);
            return this;
        }
    }
}

