/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.serverside.CustomData;
import com.facebook.ads.sdk.serverside.Event;
import com.facebook.ads.sdk.serverside.EventResponse;
import com.facebook.ads.utils.CustomDataAdapter;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRequest {
    private static Gson gson = null;
    @SerializedName(value="data")
    private List<Event> data = new ArrayList<Event>();
    @SerializedName(value="test_event_code")
    private String testEventCode = null;
    @SerializedName(value="partner_agent")
    private String partnerAgent = null;
    @SerializedName(value="namespace_id")
    private String namespaceId = null;
    @SerializedName(value="upload_id")
    private String uploadId = null;
    @SerializedName(value="upload_tag")
    private String uploadTag = null;
    @SerializedName(value="upload_source")
    private String uploadSource = null;
    private String pixelId;
    private APIContext context;

    public EventRequest(String pixelId, APIContext context) {
        this.pixelId = pixelId;
        this.context = context;
    }

    public EventRequest(String pixelId, APIContext context, List<Event> data, String testEventCode, String partnerAgent, String namespaceId, String uploadId, String uploadTag, String uploadSource) {
        this.data = data;
        this.testEventCode = testEventCode;
        this.partnerAgent = partnerAgent;
        this.pixelId = pixelId;
        this.context = context;
        this.namespaceId = namespaceId;
        this.uploadId = uploadId;
        this.uploadTag = uploadTag;
        this.uploadSource = uploadSource;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().registerTypeAdapter(CustomData.class, (Object)new CustomDataAdapter()).create();
        return gson;
    }

    public EventRequest data(List<Event> data) {
        this.data = data;
        return this;
    }

    public EventRequest addDataItem(Event dataItem) {
        this.data.add(dataItem);
        return this;
    }

    public List<Event> getData() {
        return this.data;
    }

    public void setData(List<Event> data) {
        this.data = data;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public EventRequest namespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public EventRequest uploadId(String uploadId) {
        this.uploadId = uploadId;
        return this;
    }

    public String getUploadTag() {
        return this.uploadTag;
    }

    public void setUploadTag(String uploadTag) {
        this.uploadTag = uploadTag;
    }

    public EventRequest uploadTag(String uploadTag) {
        this.uploadTag = uploadTag;
        return this;
    }

    public String getUploadSource() {
        return this.uploadSource;
    }

    public void setUploadSource(String uploadSource) {
        this.uploadSource = uploadSource;
    }

    public EventRequest uploadSource(String uploadSource) {
        this.uploadSource = uploadSource;
        return this;
    }

    public EventRequest testEventCode(String testEventCode) {
        this.testEventCode = testEventCode;
        return this;
    }

    public String getTestEventCode() {
        return this.testEventCode;
    }

    public void setTestEventCode(String testEventCode) {
        this.testEventCode = testEventCode;
    }

    public EventRequest partnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
        return this;
    }

    public String getPartnerAgent() {
        return this.partnerAgent;
    }

    public void setPartnerAgent(String partnerAgent) {
        this.partnerAgent = partnerAgent;
    }

    public EventResponse execute() throws APIException {
        AdsPixel.APIRequestCreateEvent event = this.getPixelCreateEvent();
        EventResponse response = null;
        try {
            AdsPixel pixel = event.execute();
            response = (EventResponse)gson.fromJson(pixel.getRawResponse(), EventResponse.class);
            this.context.log(String.format("Successfully sent %d event(s)", response.getEventsReceived()));
            return response;
        }
        catch (APIException e) {
            this.context.log(e.getMessage());
            throw e;
        }
    }

    public ListenableFuture<EventResponse> executeAsync() throws APIException {
        AdsPixel.APIRequestCreateEvent event = this.getPixelCreateEvent();
        ListenableFuture response = null;
        try {
            ListenableFuture<AdsPixel> pixelFuture = event.executeAsync();
            response = Futures.transformAsync(pixelFuture, (AsyncFunction)new AsyncFunction<AdsPixel, EventResponse>(){

                public ListenableFuture<EventResponse> apply(AdsPixel pixel) {
                    EventResponse eventResponse = (EventResponse)gson.fromJson(pixel.getRawResponse(), EventResponse.class);
                    EventRequest.this.context.log(String.format("Successfully sent %d event(s)", eventResponse.getEventsReceived()));
                    return Futures.immediateFuture((Object)eventResponse);
                }
            });
            return response;
        }
        catch (APIException e) {
            this.context.log(e.getMessage());
            throw e;
        }
    }

    public String getSerializedPayload() {
        List<Event> s2sData = this.getData();
        return EventRequest.getGson().toJson(s2sData);
    }

    private AdsPixel.APIRequestCreateEvent getPixelCreateEvent() {
        AdsPixel.APIRequestCreateEvent event = new AdsPixel.APIRequestCreateEvent(this.pixelId, this.context);
        event.setData(EventRequest.getGson().toJson(this.getData()));
        if (this.getTestEventCode() != null) {
            event.setTestEventCode(this.getTestEventCode());
        }
        if (this.getPartnerAgent() != null) {
            event.setPartnerAgent(this.getPartnerAgent());
        }
        if (this.getNamespaceId() != null) {
            event.setNamespaceId(this.getNamespaceId());
        }
        if (this.getUploadId() != null) {
            event.setUploadId(this.getUploadId());
        }
        if (this.getUploadTag() != null) {
            event.setUploadTag(this.getUploadTag());
        }
        if (this.getUploadSource() != null) {
            event.setUploadSource(this.getUploadSource());
        }
        return event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventRequest eventRequest = (EventRequest)o;
        return Objects.equals(this.data, eventRequest.data) && Objects.equals(this.testEventCode, eventRequest.testEventCode) && Objects.equals(this.partnerAgent, eventRequest.partnerAgent);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.testEventCode, this.partnerAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    testEventCode: ").append(this.toIndentedString(this.testEventCode)).append("\n");
        sb.append("    partnerAgent: ").append(this.toIndentedString(this.partnerAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

