/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.utils;

import com.facebook.ads.sdk.serverside.CustomData;
import com.facebook.ads.utils.ServerSideApiUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDataAdapter
implements JsonSerializer<CustomData> {
    private Gson gson = new Gson();

    public Gson getGsonInstance() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    public JsonElement serialize(CustomData src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject serializedObject = new JsonObject();
        for (Field field : src.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (field.getName() == "contents") {
                    serializedObject.addProperty(serializedName.value(), this.getGsonInstance().toJson(field.get(src)));
                    continue;
                }
                if (null == serializedName || null == field.get(src)) continue;
                String propertyValue = String.valueOf(field.get(src));
                if (field.getName() == "currency") {
                    propertyValue = ServerSideApiUtil.normalize(propertyValue, "currency");
                }
                serializedObject.addProperty(serializedName.value(), propertyValue);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        if (null != src.getCustomProperties()) {
            for (String key : src.getCustomProperties().keySet()) {
                serializedObject.addProperty(key, src.getCustomProperties().get(key));
            }
        }
        return serializedObject;
    }
}

