/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdStudy;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerStudy
extends APINode {
    @SerializedName(value="additional_info")
    private String mAdditionalInfo = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="client_name")
    private String mClientName = null;
    @SerializedName(value="emails")
    private String mEmails = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="input_ids")
    private List<String> mInputIds = null;
    @SerializedName(value="is_export")
    private Boolean mIsExport = null;
    @SerializedName(value="lift_study")
    private AdStudy mLiftStudy = null;
    @SerializedName(value="location")
    private String mLocation = null;
    @SerializedName(value="match_file_ds")
    private String mMatchFileDs = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="partner_defined_id")
    private String mPartnerDefinedId = null;
    @SerializedName(value="partner_household_graph_dataset_id")
    private String mPartnerHouseholdGraphDatasetId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="study_end_date")
    private String mStudyEndDate = null;
    @SerializedName(value="study_start_date")
    private String mStudyStartDate = null;
    @SerializedName(value="study_type")
    private String mStudyType = null;
    @SerializedName(value="submit_date")
    private String mSubmitDate = null;
    protected static Gson gson = null;

    PartnerStudy() {
    }

    public PartnerStudy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PartnerStudy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PartnerStudy fetch() throws APIException {
        PartnerStudy newInstance = PartnerStudy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PartnerStudy fetchById(Long id, APIContext context) throws APIException {
        return PartnerStudy.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PartnerStudy> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PartnerStudy.fetchByIdAsync(id.toString(), context);
    }

    public static PartnerStudy fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PartnerStudy> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PartnerStudy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PartnerStudy>(context, "", "/", "GET", PartnerStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PartnerStudy>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PartnerStudy>(context, "", "/", "GET", PartnerStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerStudy loadJSON(String json, APIContext context, String header) {
        PartnerStudy partnerStudy = (PartnerStudy)PartnerStudy.getGson().fromJson(json, PartnerStudy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerStudy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerStudy.context = context;
        partnerStudy.rawValue = json;
        partnerStudy.header = header;
        return partnerStudy;
    }

    public static APINodeList<PartnerStudy> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerStudy> partnerStudys = new APINodeList<PartnerStudy>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerStudys.add(PartnerStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return partnerStudys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerStudys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerStudys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerStudys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerStudys.add(PartnerStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerStudys.add(PartnerStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerStudys.add(PartnerStudy.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return partnerStudys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerStudys.add(PartnerStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return partnerStudys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerStudys.add(PartnerStudy.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerStudys;
                }
                partnerStudys.clear();
                partnerStudys.add(PartnerStudy.loadJSON(json, context, header));
                return partnerStudys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerStudy.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdditionalInfo() {
        return this.mAdditionalInfo;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldClientName() {
        return this.mClientName;
    }

    public String getFieldEmails() {
        return this.mEmails;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldInputIds() {
        return this.mInputIds;
    }

    public Boolean getFieldIsExport() {
        return this.mIsExport;
    }

    public AdStudy getFieldLiftStudy() {
        if (this.mLiftStudy != null) {
            this.mLiftStudy.context = this.getContext();
        }
        return this.mLiftStudy;
    }

    public String getFieldLocation() {
        return this.mLocation;
    }

    public String getFieldMatchFileDs() {
        return this.mMatchFileDs;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPartnerDefinedId() {
        return this.mPartnerDefinedId;
    }

    public String getFieldPartnerHouseholdGraphDatasetId() {
        return this.mPartnerHouseholdGraphDatasetId;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStudyEndDate() {
        return this.mStudyEndDate;
    }

    public String getFieldStudyStartDate() {
        return this.mStudyStartDate;
    }

    public String getFieldStudyType() {
        return this.mStudyType;
    }

    public String getFieldSubmitDate() {
        return this.mSubmitDate;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerStudy copyFrom(PartnerStudy instance) {
        this.mAdditionalInfo = instance.mAdditionalInfo;
        this.mBrand = instance.mBrand;
        this.mClientName = instance.mClientName;
        this.mEmails = instance.mEmails;
        this.mId = instance.mId;
        this.mInputIds = instance.mInputIds;
        this.mIsExport = instance.mIsExport;
        this.mLiftStudy = instance.mLiftStudy;
        this.mLocation = instance.mLocation;
        this.mMatchFileDs = instance.mMatchFileDs;
        this.mName = instance.mName;
        this.mPartnerDefinedId = instance.mPartnerDefinedId;
        this.mPartnerHouseholdGraphDatasetId = instance.mPartnerHouseholdGraphDatasetId;
        this.mStatus = instance.mStatus;
        this.mStudyEndDate = instance.mStudyEndDate;
        this.mStudyStartDate = instance.mStudyStartDate;
        this.mStudyType = instance.mStudyType;
        this.mSubmitDate = instance.mSubmitDate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerStudy> getParser() {
        return new APIRequest.ResponseParser<PartnerStudy>(){

            @Override
            public APINodeList<PartnerStudy> parseResponse(String response, APIContext context, APIRequest<PartnerStudy> request, String header) throws APIException.MalformedResponseException {
                return PartnerStudy.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PartnerStudy> {
        PartnerStudy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"additional_info", "brand", "client_name", "emails", "id", "input_ids", "is_export", "lift_study", "location", "match_file_ds", "name", "partner_defined_id", "partner_household_graph_dataset_id", "status", "study_end_date", "study_start_date", "study_type", "submit_date"};

        @Override
        public PartnerStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerStudy parseResponse(String response, String header) throws APIException {
            return PartnerStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PartnerStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PartnerStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PartnerStudy>(){

                public PartnerStudy apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdditionalInfoField() {
            return this.requestAdditionalInfoField(true);
        }

        public APIRequestGet requestAdditionalInfoField(boolean value) {
            this.requestField("additional_info", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestClientNameField() {
            return this.requestClientNameField(true);
        }

        public APIRequestGet requestClientNameField(boolean value) {
            this.requestField("client_name", value);
            return this;
        }

        public APIRequestGet requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGet requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInputIdsField() {
            return this.requestInputIdsField(true);
        }

        public APIRequestGet requestInputIdsField(boolean value) {
            this.requestField("input_ids", value);
            return this;
        }

        public APIRequestGet requestIsExportField() {
            return this.requestIsExportField(true);
        }

        public APIRequestGet requestIsExportField(boolean value) {
            this.requestField("is_export", value);
            return this;
        }

        public APIRequestGet requestLiftStudyField() {
            return this.requestLiftStudyField(true);
        }

        public APIRequestGet requestLiftStudyField(boolean value) {
            this.requestField("lift_study", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestMatchFileDsField() {
            return this.requestMatchFileDsField(true);
        }

        public APIRequestGet requestMatchFileDsField(boolean value) {
            this.requestField("match_file_ds", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPartnerDefinedIdField() {
            return this.requestPartnerDefinedIdField(true);
        }

        public APIRequestGet requestPartnerDefinedIdField(boolean value) {
            this.requestField("partner_defined_id", value);
            return this;
        }

        public APIRequestGet requestPartnerHouseholdGraphDatasetIdField() {
            return this.requestPartnerHouseholdGraphDatasetIdField(true);
        }

        public APIRequestGet requestPartnerHouseholdGraphDatasetIdField(boolean value) {
            this.requestField("partner_household_graph_dataset_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStudyEndDateField() {
            return this.requestStudyEndDateField(true);
        }

        public APIRequestGet requestStudyEndDateField(boolean value) {
            this.requestField("study_end_date", value);
            return this;
        }

        public APIRequestGet requestStudyStartDateField() {
            return this.requestStudyStartDateField(true);
        }

        public APIRequestGet requestStudyStartDateField(boolean value) {
            this.requestField("study_start_date", value);
            return this;
        }

        public APIRequestGet requestStudyTypeField() {
            return this.requestStudyTypeField(true);
        }

        public APIRequestGet requestStudyTypeField(boolean value) {
            this.requestField("study_type", value);
            return this;
        }

        public APIRequestGet requestSubmitDateField() {
            return this.requestSubmitDateField(true);
        }

        public APIRequestGet requestSubmitDateField(boolean value) {
            this.requestField("submit_date", value);
            return this;
        }
    }
}

