/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CopyrightReferenceContainer;
import com.facebook.ads.sdk.VideoCopyrightRule;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicVideoCopyright
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="displayed_matches_count")
    private Long mDisplayedMatchesCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="in_conflict")
    private Boolean mInConflict = null;
    @SerializedName(value="isrc")
    private String mIsrc = null;
    @SerializedName(value="match_rule")
    private VideoCopyrightRule mMatchRule = null;
    @SerializedName(value="ownership_countries")
    private List<String> mOwnershipCountries = null;
    @SerializedName(value="reference_file_status")
    private String mReferenceFileStatus = null;
    @SerializedName(value="ridge_monitoring_status")
    private String mRidgeMonitoringStatus = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    @SerializedName(value="video_asset")
    private CopyrightReferenceContainer mVideoAsset = null;
    @SerializedName(value="whitelisted_fb_users")
    private List<Object> mWhitelistedFbUsers = null;
    @SerializedName(value="whitelisted_ig_users")
    private List<String> mWhitelistedIgUsers = null;
    protected static Gson gson = null;

    MusicVideoCopyright() {
    }

    public MusicVideoCopyright(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MusicVideoCopyright(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MusicVideoCopyright fetch() throws APIException {
        MusicVideoCopyright newInstance = MusicVideoCopyright.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MusicVideoCopyright fetchById(Long id, APIContext context) throws APIException {
        return MusicVideoCopyright.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MusicVideoCopyright> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MusicVideoCopyright.fetchByIdAsync(id.toString(), context);
    }

    public static MusicVideoCopyright fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MusicVideoCopyright> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MusicVideoCopyright> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MusicVideoCopyright>(context, "", "/", "GET", MusicVideoCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MusicVideoCopyright>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MusicVideoCopyright>(context, "", "/", "GET", MusicVideoCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MusicVideoCopyright loadJSON(String json, APIContext context, String header) {
        MusicVideoCopyright musicVideoCopyright = (MusicVideoCopyright)MusicVideoCopyright.getGson().fromJson(json, MusicVideoCopyright.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(musicVideoCopyright.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        musicVideoCopyright.context = context;
        musicVideoCopyright.rawValue = json;
        musicVideoCopyright.header = header;
        return musicVideoCopyright;
    }

    public static APINodeList<MusicVideoCopyright> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MusicVideoCopyright> musicVideoCopyrights = new APINodeList<MusicVideoCopyright>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return musicVideoCopyrights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            musicVideoCopyrights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        musicVideoCopyrights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            musicVideoCopyrights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return musicVideoCopyrights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return musicVideoCopyrights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return musicVideoCopyrights;
                }
                musicVideoCopyrights.clear();
                musicVideoCopyrights.add(MusicVideoCopyright.loadJSON(json, context, header));
                return musicVideoCopyrights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MusicVideoCopyright.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Long getFieldDisplayedMatchesCount() {
        return this.mDisplayedMatchesCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldInConflict() {
        return this.mInConflict;
    }

    public String getFieldIsrc() {
        return this.mIsrc;
    }

    public VideoCopyrightRule getFieldMatchRule() {
        if (this.mMatchRule != null) {
            this.mMatchRule.context = this.getContext();
        }
        return this.mMatchRule;
    }

    public List<String> getFieldOwnershipCountries() {
        return this.mOwnershipCountries;
    }

    public String getFieldReferenceFileStatus() {
        return this.mReferenceFileStatus;
    }

    public String getFieldRidgeMonitoringStatus() {
        return this.mRidgeMonitoringStatus;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    public CopyrightReferenceContainer getFieldVideoAsset() {
        return this.mVideoAsset;
    }

    public List<Object> getFieldWhitelistedFbUsers() {
        return this.mWhitelistedFbUsers;
    }

    public List<String> getFieldWhitelistedIgUsers() {
        return this.mWhitelistedIgUsers;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MusicVideoCopyright copyFrom(MusicVideoCopyright instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mDisplayedMatchesCount = instance.mDisplayedMatchesCount;
        this.mId = instance.mId;
        this.mInConflict = instance.mInConflict;
        this.mIsrc = instance.mIsrc;
        this.mMatchRule = instance.mMatchRule;
        this.mOwnershipCountries = instance.mOwnershipCountries;
        this.mReferenceFileStatus = instance.mReferenceFileStatus;
        this.mRidgeMonitoringStatus = instance.mRidgeMonitoringStatus;
        this.mTags = instance.mTags;
        this.mUpdateTime = instance.mUpdateTime;
        this.mVideoAsset = instance.mVideoAsset;
        this.mWhitelistedFbUsers = instance.mWhitelistedFbUsers;
        this.mWhitelistedIgUsers = instance.mWhitelistedIgUsers;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MusicVideoCopyright> getParser() {
        return new APIRequest.ResponseParser<MusicVideoCopyright>(){

            @Override
            public APINodeList<MusicVideoCopyright> parseResponse(String response, APIContext context, APIRequest<MusicVideoCopyright> request, String header) throws APIException.MalformedResponseException {
                return MusicVideoCopyright.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MusicVideoCopyright> {
        MusicVideoCopyright lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "displayed_matches_count", "id", "in_conflict", "isrc", "match_rule", "ownership_countries", "reference_file_status", "ridge_monitoring_status", "tags", "update_time", "video_asset", "whitelisted_fb_users", "whitelisted_ig_users"};

        @Override
        public MusicVideoCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MusicVideoCopyright parseResponse(String response, String header) throws APIException {
            return MusicVideoCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MusicVideoCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MusicVideoCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MusicVideoCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MusicVideoCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MusicVideoCopyright>(){

                public MusicVideoCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDisplayedMatchesCountField() {
            return this.requestDisplayedMatchesCountField(true);
        }

        public APIRequestGet requestDisplayedMatchesCountField(boolean value) {
            this.requestField("displayed_matches_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInConflictField() {
            return this.requestInConflictField(true);
        }

        public APIRequestGet requestInConflictField(boolean value) {
            this.requestField("in_conflict", value);
            return this;
        }

        public APIRequestGet requestIsrcField() {
            return this.requestIsrcField(true);
        }

        public APIRequestGet requestIsrcField(boolean value) {
            this.requestField("isrc", value);
            return this;
        }

        public APIRequestGet requestMatchRuleField() {
            return this.requestMatchRuleField(true);
        }

        public APIRequestGet requestMatchRuleField(boolean value) {
            this.requestField("match_rule", value);
            return this;
        }

        public APIRequestGet requestOwnershipCountriesField() {
            return this.requestOwnershipCountriesField(true);
        }

        public APIRequestGet requestOwnershipCountriesField(boolean value) {
            this.requestField("ownership_countries", value);
            return this;
        }

        public APIRequestGet requestReferenceFileStatusField() {
            return this.requestReferenceFileStatusField(true);
        }

        public APIRequestGet requestReferenceFileStatusField(boolean value) {
            this.requestField("reference_file_status", value);
            return this;
        }

        public APIRequestGet requestRidgeMonitoringStatusField() {
            return this.requestRidgeMonitoringStatusField(true);
        }

        public APIRequestGet requestRidgeMonitoringStatusField(boolean value) {
            this.requestField("ridge_monitoring_status", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }

        public APIRequestGet requestVideoAssetField() {
            return this.requestVideoAssetField(true);
        }

        public APIRequestGet requestVideoAssetField(boolean value) {
            this.requestField("video_asset", value);
            return this;
        }

        public APIRequestGet requestWhitelistedFbUsersField() {
            return this.requestWhitelistedFbUsersField(true);
        }

        public APIRequestGet requestWhitelistedFbUsersField(boolean value) {
            this.requestField("whitelisted_fb_users", value);
            return this;
        }

        public APIRequestGet requestWhitelistedIgUsersField() {
            return this.requestWhitelistedIgUsersField(true);
        }

        public APIRequestGet requestWhitelistedIgUsersField(boolean value) {
            this.requestField("whitelisted_ig_users", value);
            return this;
        }
    }
}

