/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaFingerprint
extends APINode {
    @SerializedName(value="duration_in_sec")
    private Double mDurationInSec = null;
    @SerializedName(value="fingerprint_content_type")
    private String mFingerprintContentType = null;
    @SerializedName(value="fingerprint_type")
    private String mFingerprintType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="metadata")
    private Object mMetadata = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="universal_content_id")
    private String mUniversalContentId = null;
    protected static Gson gson = null;

    MediaFingerprint() {
    }

    public MediaFingerprint(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MediaFingerprint(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MediaFingerprint fetch() throws APIException {
        MediaFingerprint newInstance = MediaFingerprint.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MediaFingerprint fetchById(Long id, APIContext context) throws APIException {
        return MediaFingerprint.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MediaFingerprint> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MediaFingerprint.fetchByIdAsync(id.toString(), context);
    }

    public static MediaFingerprint fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MediaFingerprint> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MediaFingerprint> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MediaFingerprint>(context, "", "/", "GET", MediaFingerprint.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MediaFingerprint>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MediaFingerprint>(context, "", "/", "GET", MediaFingerprint.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MediaFingerprint loadJSON(String json, APIContext context, String header) {
        MediaFingerprint mediaFingerprint = (MediaFingerprint)MediaFingerprint.getGson().fromJson(json, MediaFingerprint.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(mediaFingerprint.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        mediaFingerprint.context = context;
        mediaFingerprint.rawValue = json;
        mediaFingerprint.header = header;
        return mediaFingerprint;
    }

    public static APINodeList<MediaFingerprint> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MediaFingerprint> mediaFingerprints = new APINodeList<MediaFingerprint>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        mediaFingerprints.add(MediaFingerprint.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return mediaFingerprints;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            mediaFingerprints.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        mediaFingerprints.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            mediaFingerprints.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            mediaFingerprints.add(MediaFingerprint.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                mediaFingerprints.add(MediaFingerprint.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            mediaFingerprints.add(MediaFingerprint.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return mediaFingerprints;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        mediaFingerprints.add(MediaFingerprint.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return mediaFingerprints;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        mediaFingerprints.add(MediaFingerprint.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return mediaFingerprints;
                }
                mediaFingerprints.clear();
                mediaFingerprints.add(MediaFingerprint.loadJSON(json, context, header));
                return mediaFingerprints;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MediaFingerprint.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Double getFieldDurationInSec() {
        return this.mDurationInSec;
    }

    public String getFieldFingerprintContentType() {
        return this.mFingerprintContentType;
    }

    public String getFieldFingerprintType() {
        return this.mFingerprintType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldMetadata() {
        return this.mMetadata;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldUniversalContentId() {
        return this.mUniversalContentId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MediaFingerprint copyFrom(MediaFingerprint instance) {
        this.mDurationInSec = instance.mDurationInSec;
        this.mFingerprintContentType = instance.mFingerprintContentType;
        this.mFingerprintType = instance.mFingerprintType;
        this.mId = instance.mId;
        this.mMetadata = instance.mMetadata;
        this.mTitle = instance.mTitle;
        this.mUniversalContentId = instance.mUniversalContentId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MediaFingerprint> getParser() {
        return new APIRequest.ResponseParser<MediaFingerprint>(){

            @Override
            public APINodeList<MediaFingerprint> parseResponse(String response, APIContext context, APIRequest<MediaFingerprint> request, String header) throws APIException.MalformedResponseException {
                return MediaFingerprint.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFingerprintContentType {
        VALUE_AM_SONGTRACK("AM_SONGTRACK"),
        VALUE_EPISODE("EPISODE"),
        VALUE_MOVIE("MOVIE"),
        VALUE_OTHER("OTHER"),
        VALUE_SONGTRACK("SONGTRACK");

        private String value;

        private EnumFingerprintContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<MediaFingerprint> {
        MediaFingerprint lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"duration_in_sec", "fingerprint_content_type", "fingerprint_type", "id", "metadata", "title", "universal_content_id"};

        @Override
        public MediaFingerprint getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MediaFingerprint parseResponse(String response, String header) throws APIException {
            return MediaFingerprint.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MediaFingerprint execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MediaFingerprint execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MediaFingerprint> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MediaFingerprint> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MediaFingerprint>(){

                public MediaFingerprint apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDurationInSecField() {
            return this.requestDurationInSecField(true);
        }

        public APIRequestGet requestDurationInSecField(boolean value) {
            this.requestField("duration_in_sec", value);
            return this;
        }

        public APIRequestGet requestFingerprintContentTypeField() {
            return this.requestFingerprintContentTypeField(true);
        }

        public APIRequestGet requestFingerprintContentTypeField(boolean value) {
            this.requestField("fingerprint_content_type", value);
            return this;
        }

        public APIRequestGet requestFingerprintTypeField() {
            return this.requestFingerprintTypeField(true);
        }

        public APIRequestGet requestFingerprintTypeField(boolean value) {
            this.requestField("fingerprint_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMetadataField() {
            return this.requestMetadataField(true);
        }

        public APIRequestGet requestMetadataField(boolean value) {
            this.requestField("metadata", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestUniversalContentIdField() {
            return this.requestUniversalContentIdField(true);
        }

        public APIRequestGet requestUniversalContentIdField(boolean value) {
            this.requestField("universal_content_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

