/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommerceOrder
extends APINode {
    @SerializedName(value="buyer_details")
    private Object mBuyerDetails = null;
    @SerializedName(value="channel")
    private String mChannel = null;
    @SerializedName(value="created")
    private String mCreated = null;
    @SerializedName(value="estimated_payment_details")
    private Object mEstimatedPaymentDetails = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_group_buy")
    private Boolean mIsGroupBuy = null;
    @SerializedName(value="last_updated")
    private String mLastUpdated = null;
    @SerializedName(value="merchant_order_id")
    private String mMerchantOrderId = null;
    @SerializedName(value="order_status")
    private Object mOrderStatus = null;
    @SerializedName(value="selected_shipping_option")
    private Object mSelectedShippingOption = null;
    @SerializedName(value="ship_by_date")
    private String mShipByDate = null;
    @SerializedName(value="shipping_address")
    private Object mShippingAddress = null;
    protected static Gson gson = null;

    CommerceOrder() {
    }

    public CommerceOrder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CommerceOrder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CommerceOrder fetch() throws APIException {
        CommerceOrder newInstance = CommerceOrder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CommerceOrder fetchById(Long id, APIContext context) throws APIException {
        return CommerceOrder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CommerceOrder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CommerceOrder.fetchByIdAsync(id.toString(), context);
    }

    public static CommerceOrder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CommerceOrder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CommerceOrder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CommerceOrder>(context, "", "/", "GET", CommerceOrder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CommerceOrder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CommerceOrder>(context, "", "/", "GET", CommerceOrder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CommerceOrder loadJSON(String json, APIContext context, String header) {
        CommerceOrder commerceOrder = (CommerceOrder)CommerceOrder.getGson().fromJson(json, CommerceOrder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(commerceOrder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        commerceOrder.context = context;
        commerceOrder.rawValue = json;
        commerceOrder.header = header;
        return commerceOrder;
    }

    public static APINodeList<CommerceOrder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CommerceOrder> commerceOrders = new APINodeList<CommerceOrder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        commerceOrders.add(CommerceOrder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return commerceOrders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            commerceOrders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        commerceOrders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            commerceOrders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            commerceOrders.add(CommerceOrder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                commerceOrders.add(CommerceOrder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            commerceOrders.add(CommerceOrder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return commerceOrders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        commerceOrders.add(CommerceOrder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return commerceOrders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        commerceOrders.add(CommerceOrder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return commerceOrders;
                }
                commerceOrders.clear();
                commerceOrders.add(CommerceOrder.loadJSON(json, context, header));
                return commerceOrders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CommerceOrder.getGson().toJson((Object)this);
    }

    public APIRequestCreateAcknowledgeOrder createAcknowledgeOrder() {
        return new APIRequestCreateAcknowledgeOrder(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCancellations getCancellations() {
        return new APIRequestGetCancellations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCancellation createCancellation() {
        return new APIRequestCreateCancellation(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetItems getItems() {
        return new APIRequestGetItems(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPayments getPayments() {
        return new APIRequestGetPayments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPromotions getPromotions() {
        return new APIRequestGetPromotions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRefunds getRefunds() {
        return new APIRequestGetRefunds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateRefund createRefund() {
        return new APIRequestCreateRefund(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReturns getReturns() {
        return new APIRequestGetReturns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetShipments getShipments() {
        return new APIRequestGetShipments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateShipment createShipment() {
        return new APIRequestCreateShipment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUpdateShipment createUpdateShipment() {
        return new APIRequestCreateUpdateShipment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldBuyerDetails() {
        return this.mBuyerDetails;
    }

    public String getFieldChannel() {
        return this.mChannel;
    }

    public String getFieldCreated() {
        return this.mCreated;
    }

    public Object getFieldEstimatedPaymentDetails() {
        return this.mEstimatedPaymentDetails;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsGroupBuy() {
        return this.mIsGroupBuy;
    }

    public String getFieldLastUpdated() {
        return this.mLastUpdated;
    }

    public String getFieldMerchantOrderId() {
        return this.mMerchantOrderId;
    }

    public Object getFieldOrderStatus() {
        return this.mOrderStatus;
    }

    public Object getFieldSelectedShippingOption() {
        return this.mSelectedShippingOption;
    }

    public String getFieldShipByDate() {
        return this.mShipByDate;
    }

    public Object getFieldShippingAddress() {
        return this.mShippingAddress;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CommerceOrder copyFrom(CommerceOrder instance) {
        this.mBuyerDetails = instance.mBuyerDetails;
        this.mChannel = instance.mChannel;
        this.mCreated = instance.mCreated;
        this.mEstimatedPaymentDetails = instance.mEstimatedPaymentDetails;
        this.mId = instance.mId;
        this.mIsGroupBuy = instance.mIsGroupBuy;
        this.mLastUpdated = instance.mLastUpdated;
        this.mMerchantOrderId = instance.mMerchantOrderId;
        this.mOrderStatus = instance.mOrderStatus;
        this.mSelectedShippingOption = instance.mSelectedShippingOption;
        this.mShipByDate = instance.mShipByDate;
        this.mShippingAddress = instance.mShippingAddress;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CommerceOrder> getParser() {
        return new APIRequest.ResponseParser<CommerceOrder>(){

            @Override
            public APINodeList<CommerceOrder> parseResponse(String response, APIContext context, APIRequest<CommerceOrder> request, String header) throws APIException.MalformedResponseException {
                return CommerceOrder.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatuses {
        VALUE_APPROVED("APPROVED"),
        VALUE_DISAPPROVED("DISAPPROVED"),
        VALUE_MERCHANT_MARKED_COMPLETED("MERCHANT_MARKED_COMPLETED"),
        VALUE_REFUNDED("REFUNDED"),
        VALUE_REQUESTED("REQUESTED");

        private String value;

        private EnumStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumState {
        VALUE_COMPLETED("COMPLETED"),
        VALUE_CREATED("CREATED"),
        VALUE_FB_PROCESSING("FB_PROCESSING"),
        VALUE_IN_PROGRESS("IN_PROGRESS");

        private String value;

        private EnumState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFilters {
        VALUE_HAS_CANCELLATIONS("HAS_CANCELLATIONS"),
        VALUE_HAS_FULFILLMENTS("HAS_FULFILLMENTS"),
        VALUE_HAS_REFUNDS("HAS_REFUNDS"),
        VALUE_NO_CANCELLATIONS("NO_CANCELLATIONS"),
        VALUE_NO_REFUNDS("NO_REFUNDS"),
        VALUE_NO_SHIPMENTS("NO_SHIPMENTS");

        private String value;

        private EnumFilters(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumReasonCode {
        VALUE_BUYERS_REMORSE("BUYERS_REMORSE"),
        VALUE_DAMAGED_GOODS("DAMAGED_GOODS"),
        VALUE_NOT_AS_DESCRIBED("NOT_AS_DESCRIBED"),
        VALUE_QUALITY_ISSUE("QUALITY_ISSUE"),
        VALUE_REFUND_COMPROMISED("REFUND_COMPROMISED"),
        VALUE_REFUND_FOR_RETURN("REFUND_FOR_RETURN"),
        VALUE_REFUND_REASON_OTHER("REFUND_REASON_OTHER"),
        VALUE_REFUND_SFI_FAKE("REFUND_SFI_FAKE"),
        VALUE_REFUND_SFI_REAL("REFUND_SFI_REAL"),
        VALUE_WRONG_ITEM("WRONG_ITEM");

        private String value;

        private EnumReasonCode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"buyer_details", "channel", "created", "estimated_payment_details", "id", "is_group_buy", "last_updated", "merchant_order_id", "order_status", "selected_shipping_option", "ship_by_date", "shipping_address"};

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBuyerDetailsField() {
            return this.requestBuyerDetailsField(true);
        }

        public APIRequestGet requestBuyerDetailsField(boolean value) {
            this.requestField("buyer_details", value);
            return this;
        }

        public APIRequestGet requestChannelField() {
            return this.requestChannelField(true);
        }

        public APIRequestGet requestChannelField(boolean value) {
            this.requestField("channel", value);
            return this;
        }

        public APIRequestGet requestCreatedField() {
            return this.requestCreatedField(true);
        }

        public APIRequestGet requestCreatedField(boolean value) {
            this.requestField("created", value);
            return this;
        }

        public APIRequestGet requestEstimatedPaymentDetailsField() {
            return this.requestEstimatedPaymentDetailsField(true);
        }

        public APIRequestGet requestEstimatedPaymentDetailsField(boolean value) {
            this.requestField("estimated_payment_details", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsGroupBuyField() {
            return this.requestIsGroupBuyField(true);
        }

        public APIRequestGet requestIsGroupBuyField(boolean value) {
            this.requestField("is_group_buy", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedField() {
            return this.requestLastUpdatedField(true);
        }

        public APIRequestGet requestLastUpdatedField(boolean value) {
            this.requestField("last_updated", value);
            return this;
        }

        public APIRequestGet requestMerchantOrderIdField() {
            return this.requestMerchantOrderIdField(true);
        }

        public APIRequestGet requestMerchantOrderIdField(boolean value) {
            this.requestField("merchant_order_id", value);
            return this;
        }

        public APIRequestGet requestOrderStatusField() {
            return this.requestOrderStatusField(true);
        }

        public APIRequestGet requestOrderStatusField(boolean value) {
            this.requestField("order_status", value);
            return this;
        }

        public APIRequestGet requestSelectedShippingOptionField() {
            return this.requestSelectedShippingOptionField(true);
        }

        public APIRequestGet requestSelectedShippingOptionField(boolean value) {
            this.requestField("selected_shipping_option", value);
            return this;
        }

        public APIRequestGet requestShipByDateField() {
            return this.requestShipByDateField(true);
        }

        public APIRequestGet requestShipByDateField(boolean value) {
            this.requestField("ship_by_date", value);
            return this;
        }

        public APIRequestGet requestShippingAddressField() {
            return this.requestShippingAddressField(true);
        }

        public APIRequestGet requestShippingAddressField(boolean value) {
            this.requestField("shipping_address", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUpdateShipment
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"fulfillment_id", "idempotency_key", "tracking_info"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateUpdateShipment.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUpdateShipment(String nodeId, APIContext context) {
            super(context, nodeId, "/update_shipment", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUpdateShipment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUpdateShipment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUpdateShipment setFulfillmentId(String fulfillmentId) {
            this.setParam("fulfillment_id", fulfillmentId);
            return this;
        }

        public APIRequestCreateUpdateShipment setIdempotencyKey(String idempotencyKey) {
            this.setParam("idempotency_key", idempotencyKey);
            return this;
        }

        public APIRequestCreateUpdateShipment setTrackingInfo(Map<String, String> trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateUpdateShipment setTrackingInfo(String trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateUpdateShipment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUpdateShipment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUpdateShipment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUpdateShipment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUpdateShipment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUpdateShipment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateShipment
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"external_redemption_link", "external_shipment_id", "fulfillment", "idempotency_key", "items", "merchant_order_reference", "shipment_origin_postal_code", "shipping_tax_details", "tracking_info"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateShipment.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateShipment(String nodeId, APIContext context) {
            super(context, nodeId, "/shipments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateShipment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateShipment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateShipment setExternalRedemptionLink(String externalRedemptionLink) {
            this.setParam("external_redemption_link", externalRedemptionLink);
            return this;
        }

        public APIRequestCreateShipment setExternalShipmentId(String externalShipmentId) {
            this.setParam("external_shipment_id", externalShipmentId);
            return this;
        }

        public APIRequestCreateShipment setFulfillment(Map<String, String> fulfillment) {
            this.setParam("fulfillment", fulfillment);
            return this;
        }

        public APIRequestCreateShipment setFulfillment(String fulfillment) {
            this.setParam("fulfillment", fulfillment);
            return this;
        }

        public APIRequestCreateShipment setIdempotencyKey(String idempotencyKey) {
            this.setParam("idempotency_key", idempotencyKey);
            return this;
        }

        public APIRequestCreateShipment setItems(List<Map<String, String>> items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateShipment setItems(String items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateShipment setMerchantOrderReference(String merchantOrderReference) {
            this.setParam("merchant_order_reference", merchantOrderReference);
            return this;
        }

        public APIRequestCreateShipment setShipmentOriginPostalCode(String shipmentOriginPostalCode) {
            this.setParam("shipment_origin_postal_code", shipmentOriginPostalCode);
            return this;
        }

        public APIRequestCreateShipment setShippingTaxDetails(Map<String, String> shippingTaxDetails) {
            this.setParam("shipping_tax_details", shippingTaxDetails);
            return this;
        }

        public APIRequestCreateShipment setShippingTaxDetails(String shippingTaxDetails) {
            this.setParam("shipping_tax_details", shippingTaxDetails);
            return this;
        }

        public APIRequestCreateShipment setTrackingInfo(Map<String, String> trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateShipment setTrackingInfo(String trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateShipment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateShipment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateShipment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateShipment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateShipment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateShipment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetShipments
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetShipments.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetShipments(String nodeId, APIContext context) {
            super(context, nodeId, "/shipments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetShipments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetShipments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetShipments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetShipments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetShipments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetShipments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetShipments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetShipments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReturns
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"merchant_return_id", "statuses"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetReturns.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReturns(String nodeId, APIContext context) {
            super(context, nodeId, "/returns", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReturns setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReturns setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReturns setMerchantReturnId(String merchantReturnId) {
            this.setParam("merchant_return_id", merchantReturnId);
            return this;
        }

        public APIRequestGetReturns setStatuses(List<EnumStatuses> statuses) {
            this.setParam("statuses", statuses);
            return this;
        }

        public APIRequestGetReturns setStatuses(String statuses) {
            this.setParam("statuses", statuses);
            return this;
        }

        public APIRequestGetReturns requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReturns requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReturns requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReturns requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReturns requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReturns requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateRefund
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"deductions", "idempotency_key", "items", "reason_code", "reason_text", "return_id", "shipping"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateRefund.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateRefund(String nodeId, APIContext context) {
            super(context, nodeId, "/refunds", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateRefund setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateRefund setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateRefund setDeductions(List<Map<String, String>> deductions) {
            this.setParam("deductions", deductions);
            return this;
        }

        public APIRequestCreateRefund setDeductions(String deductions) {
            this.setParam("deductions", deductions);
            return this;
        }

        public APIRequestCreateRefund setIdempotencyKey(String idempotencyKey) {
            this.setParam("idempotency_key", idempotencyKey);
            return this;
        }

        public APIRequestCreateRefund setItems(List<Map<String, String>> items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateRefund setItems(String items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateRefund setReasonCode(EnumReasonCode reasonCode) {
            this.setParam("reason_code", (Object)reasonCode);
            return this;
        }

        public APIRequestCreateRefund setReasonCode(String reasonCode) {
            this.setParam("reason_code", reasonCode);
            return this;
        }

        public APIRequestCreateRefund setReasonText(String reasonText) {
            this.setParam("reason_text", reasonText);
            return this;
        }

        public APIRequestCreateRefund setReturnId(String returnId) {
            this.setParam("return_id", returnId);
            return this;
        }

        public APIRequestCreateRefund setShipping(Map<String, String> shipping) {
            this.setParam("shipping", shipping);
            return this;
        }

        public APIRequestCreateRefund setShipping(String shipping) {
            this.setParam("shipping", shipping);
            return this;
        }

        public APIRequestCreateRefund requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateRefund requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateRefund requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateRefund requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateRefund requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateRefund requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetRefunds
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetRefunds.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRefunds(String nodeId, APIContext context) {
            super(context, nodeId, "/refunds", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRefunds setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRefunds setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRefunds requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRefunds requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRefunds requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRefunds requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRefunds requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRefunds requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPromotions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPromotions.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPromotions(String nodeId, APIContext context) {
            super(context, nodeId, "/promotions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPromotions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPromotions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPromotions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPromotions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPromotions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPromotions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPayments
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPayments.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPayments(String nodeId, APIContext context) {
            super(context, nodeId, "/payments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPayments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPayments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPayments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPayments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPayments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPayments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPayments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPayments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetItems
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetItems.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetItems(String nodeId, APIContext context) {
            super(context, nodeId, "/items", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetItems setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetItems setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetItems requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetItems requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetItems requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetItems requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetItems requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetItems requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCancellation
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"cancel_reason", "idempotency_key", "items", "restock_items"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateCancellation.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCancellation(String nodeId, APIContext context) {
            super(context, nodeId, "/cancellations", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCancellation setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCancellation setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCancellation setCancelReason(Map<String, String> cancelReason) {
            this.setParam("cancel_reason", cancelReason);
            return this;
        }

        public APIRequestCreateCancellation setCancelReason(String cancelReason) {
            this.setParam("cancel_reason", cancelReason);
            return this;
        }

        public APIRequestCreateCancellation setIdempotencyKey(String idempotencyKey) {
            this.setParam("idempotency_key", idempotencyKey);
            return this;
        }

        public APIRequestCreateCancellation setItems(List<Map<String, String>> items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateCancellation setItems(String items) {
            this.setParam("items", items);
            return this;
        }

        public APIRequestCreateCancellation setRestockItems(Boolean restockItems) {
            this.setParam("restock_items", restockItems);
            return this;
        }

        public APIRequestCreateCancellation setRestockItems(String restockItems) {
            this.setParam("restock_items", restockItems);
            return this;
        }

        public APIRequestCreateCancellation requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCancellation requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCancellation requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCancellation requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCancellation requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCancellation requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCancellations
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetCancellations.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCancellations(String nodeId, APIContext context) {
            super(context, nodeId, "/cancellations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCancellations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCancellations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCancellations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCancellations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCancellations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCancellations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCancellations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCancellations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAcknowledgeOrder
    extends APIRequest<CommerceOrder> {
        CommerceOrder lastResponse = null;
        public static final String[] PARAMS = new String[]{"idempotency_key", "merchant_order_reference"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CommerceOrder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CommerceOrder parseResponse(String response, String header) throws APIException {
            return CommerceOrder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CommerceOrder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CommerceOrder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CommerceOrder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CommerceOrder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CommerceOrder>(){

                public CommerceOrder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateAcknowledgeOrder.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAcknowledgeOrder(String nodeId, APIContext context) {
            super(context, nodeId, "/acknowledge_order", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAcknowledgeOrder setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAcknowledgeOrder setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAcknowledgeOrder setIdempotencyKey(String idempotencyKey) {
            this.setParam("idempotency_key", idempotencyKey);
            return this;
        }

        public APIRequestCreateAcknowledgeOrder setMerchantOrderReference(String merchantOrderReference) {
            this.setParam("merchant_order_reference", merchantOrderReference);
            return this;
        }

        public APIRequestCreateAcknowledgeOrder requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAcknowledgeOrder requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAcknowledgeOrder requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAcknowledgeOrder requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAcknowledgeOrder requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAcknowledgeOrder requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

