/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTransparencyStatus
extends APINode {
    @SerializedName(value="grace_period_expiration_date")
    private String mGracePeriodExpirationDate = null;
    @SerializedName(value="has_owning_business")
    private Boolean mHasOwningBusiness = null;
    @SerializedName(value="is_satisfied")
    private Boolean mIsSatisfied = null;
    @SerializedName(value="owning_business_requirements")
    private Object mOwningBusinessRequirements = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ClientTransparencyStatus loadJSON(String json, APIContext context, String header) {
        ClientTransparencyStatus clientTransparencyStatus = (ClientTransparencyStatus)ClientTransparencyStatus.getGson().fromJson(json, ClientTransparencyStatus.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(clientTransparencyStatus.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        clientTransparencyStatus.context = context;
        clientTransparencyStatus.rawValue = json;
        clientTransparencyStatus.header = header;
        return clientTransparencyStatus;
    }

    public static APINodeList<ClientTransparencyStatus> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ClientTransparencyStatus> clientTransparencyStatuss = new APINodeList<ClientTransparencyStatus>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return clientTransparencyStatuss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            clientTransparencyStatuss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        clientTransparencyStatuss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            clientTransparencyStatuss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return clientTransparencyStatuss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return clientTransparencyStatuss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return clientTransparencyStatuss;
                }
                clientTransparencyStatuss.clear();
                clientTransparencyStatuss.add(ClientTransparencyStatus.loadJSON(json, context, header));
                return clientTransparencyStatuss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ClientTransparencyStatus.getGson().toJson((Object)this);
    }

    public String getFieldGracePeriodExpirationDate() {
        return this.mGracePeriodExpirationDate;
    }

    public ClientTransparencyStatus setFieldGracePeriodExpirationDate(String value) {
        this.mGracePeriodExpirationDate = value;
        return this;
    }

    public Boolean getFieldHasOwningBusiness() {
        return this.mHasOwningBusiness;
    }

    public ClientTransparencyStatus setFieldHasOwningBusiness(Boolean value) {
        this.mHasOwningBusiness = value;
        return this;
    }

    public Boolean getFieldIsSatisfied() {
        return this.mIsSatisfied;
    }

    public ClientTransparencyStatus setFieldIsSatisfied(Boolean value) {
        this.mIsSatisfied = value;
        return this;
    }

    public Object getFieldOwningBusinessRequirements() {
        return this.mOwningBusinessRequirements;
    }

    public ClientTransparencyStatus setFieldOwningBusinessRequirements(Object value) {
        this.mOwningBusinessRequirements = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ClientTransparencyStatus copyFrom(ClientTransparencyStatus instance) {
        this.mGracePeriodExpirationDate = instance.mGracePeriodExpirationDate;
        this.mHasOwningBusiness = instance.mHasOwningBusiness;
        this.mIsSatisfied = instance.mIsSatisfied;
        this.mOwningBusinessRequirements = instance.mOwningBusinessRequirements;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ClientTransparencyStatus> getParser() {
        return new APIRequest.ResponseParser<ClientTransparencyStatus>(){

            @Override
            public APINodeList<ClientTransparencyStatus> parseResponse(String response, APIContext context, APIRequest<ClientTransparencyStatus> request, String header) throws APIException.MalformedResponseException {
                return ClientTransparencyStatus.parseResponse(response, context, request, header);
            }
        };
    }
}

