/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountAdVolume
extends APINode {
    @SerializedName(value="actor_id")
    private String mActorId = null;
    @SerializedName(value="ads_running_or_in_review_count")
    private Long mAdsRunningOrInReviewCount = null;
    @SerializedName(value="current_account_ads_running_or_in_review_count")
    private Long mCurrentAccountAdsRunningOrInReviewCount = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdAccountAdVolume loadJSON(String json, APIContext context, String header) {
        AdAccountAdVolume adAccountAdVolume = (AdAccountAdVolume)AdAccountAdVolume.getGson().fromJson(json, AdAccountAdVolume.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountAdVolume.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountAdVolume.context = context;
        adAccountAdVolume.rawValue = json;
        adAccountAdVolume.header = header;
        return adAccountAdVolume;
    }

    public static APINodeList<AdAccountAdVolume> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountAdVolume> adAccountAdVolumes = new APINodeList<AdAccountAdVolume>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountAdVolumes;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountAdVolumes.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountAdVolumes.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountAdVolumes.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountAdVolumes;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountAdVolumes;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountAdVolumes;
                }
                adAccountAdVolumes.clear();
                adAccountAdVolumes.add(AdAccountAdVolume.loadJSON(json, context, header));
                return adAccountAdVolumes;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountAdVolume.getGson().toJson((Object)this);
    }

    public String getFieldActorId() {
        return this.mActorId;
    }

    public AdAccountAdVolume setFieldActorId(String value) {
        this.mActorId = value;
        return this;
    }

    public Long getFieldAdsRunningOrInReviewCount() {
        return this.mAdsRunningOrInReviewCount;
    }

    public AdAccountAdVolume setFieldAdsRunningOrInReviewCount(Long value) {
        this.mAdsRunningOrInReviewCount = value;
        return this;
    }

    public Long getFieldCurrentAccountAdsRunningOrInReviewCount() {
        return this.mCurrentAccountAdsRunningOrInReviewCount;
    }

    public AdAccountAdVolume setFieldCurrentAccountAdsRunningOrInReviewCount(Long value) {
        this.mCurrentAccountAdsRunningOrInReviewCount = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountAdVolume copyFrom(AdAccountAdVolume instance) {
        this.mActorId = instance.mActorId;
        this.mAdsRunningOrInReviewCount = instance.mAdsRunningOrInReviewCount;
        this.mCurrentAccountAdsRunningOrInReviewCount = instance.mCurrentAccountAdsRunningOrInReviewCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountAdVolume> getParser() {
        return new APIRequest.ResponseParser<AdAccountAdVolume>(){

            @Override
            public APINodeList<AdAccountAdVolume> parseResponse(String response, APIContext context, APIRequest<AdAccountAdVolume> request, String header) throws APIException.MalformedResponseException {
                return AdAccountAdVolume.parseResponse(response, context, request, header);
            }
        };
    }
}

