/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.utils;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSideApiUtil {
    private static Pattern emailPattern = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
    private static final Set<String> ISO_COUNTRY_LIST = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
    private static final Set<String> ISO_CURRENCY_LIST = ServerSideApiUtil.GetISOCurrencyCodeList();

    public static String hash(String input) {
        return Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
    }

    public static String normalize(String token, String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required for normalizing a particular type");
        }
        String result = token;
        token = token.trim().toLowerCase();
        if ("em".equals(fieldName)) {
            result = ServerSideApiUtil.validateEmail(token);
        } else if ("ph".equals(fieldName)) {
            result = ServerSideApiUtil.normalizePhoneNumber(token);
        } else if ("zp".equals(fieldName)) {
            result = ServerSideApiUtil.normalizePostalCode(token);
        } else if ("ct".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeCity(token);
        } else if ("country".equals(fieldName)) {
            result = ServerSideApiUtil.validateCountry(token);
        } else if ("st".equals(fieldName)) {
            result = ServerSideApiUtil.normalizeState(token);
        } else if ("currency".equals(fieldName)) {
            result = ServerSideApiUtil.validateCurrency(token);
        }
        return result;
    }

    private static String normalizeCity(String city) {
        city = city.replaceAll("[0-9]", "");
        city = city.replaceAll(" ", "");
        city = city.replaceAll("[\\-\\+\\.\\^:,\\{\\}\\(\\)\\$]", "");
        return city;
    }

    private static String validateCountry(String country) {
        if (country.length() != 2) {
            throw new IllegalArgumentException("country: '" + country + "' must be a 2-letter ISO code format");
        }
        if (!ISO_COUNTRY_LIST.contains(country.toUpperCase())) {
            throw new IllegalArgumentException("country: '" + country + "' is not in the allowed Country list");
        }
        return country;
    }

    private static String validateCurrency(String currency) {
        if (currency.length() != 3) {
            throw new IllegalArgumentException("currency: '" + currency + "' must be a 3-letter ISO code format");
        }
        if (!ISO_CURRENCY_LIST.contains(currency)) {
            throw new IllegalArgumentException("currency: '" + currency + "' is not in the allowed Currency list");
        }
        return currency;
    }

    private static String normalizePhoneNumber(String phoneNumber) {
        phoneNumber = phoneNumber.replaceAll("[\\-\\s]+", "");
        return phoneNumber;
    }

    private static String validateEmail(String email) {
        if (!ServerSideApiUtil.isValidEmail(email)) {
            throw new IllegalArgumentException("Email should be a valid");
        }
        return email;
    }

    private static String normalizePostalCode(String postalCode) {
        postalCode = postalCode.split("-")[0];
        return postalCode;
    }

    private static String normalizeState(String state) {
        state = state.replaceAll("[^a-z]", "");
        return state;
    }

    private static boolean isValidEmail(String email) {
        Matcher m = emailPattern.matcher(email);
        return m.matches();
    }

    private static HashSet<String> GetISOCurrencyCodeList() {
        Set<Currency> availableCurrencies = Currency.getAvailableCurrencies();
        HashSet<String> currencyCodeList = new HashSet<String>();
        for (Currency currency : availableCurrencies) {
            currencyCodeList.add(currency.getCurrencyCode().toLowerCase());
        }
        return currencyCodeList;
    }
}

