/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhatsAppBusinessProfile
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name_verification")
    private Object mNameVerification = null;
    @SerializedName(value="verified_name")
    private String mVerifiedName = null;
    protected static Gson gson = null;

    WhatsAppBusinessProfile() {
    }

    public WhatsAppBusinessProfile(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WhatsAppBusinessProfile(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WhatsAppBusinessProfile fetch() throws APIException {
        WhatsAppBusinessProfile newInstance = WhatsAppBusinessProfile.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WhatsAppBusinessProfile fetchById(Long id, APIContext context) throws APIException {
        return WhatsAppBusinessProfile.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WhatsAppBusinessProfile> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WhatsAppBusinessProfile.fetchByIdAsync(id.toString(), context);
    }

    public static WhatsAppBusinessProfile fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WhatsAppBusinessProfile> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WhatsAppBusinessProfile> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WhatsAppBusinessProfile>(context, "", "/", "GET", WhatsAppBusinessProfile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WhatsAppBusinessProfile>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WhatsAppBusinessProfile>(context, "", "/", "GET", WhatsAppBusinessProfile.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WhatsAppBusinessProfile loadJSON(String json, APIContext context, String header) {
        WhatsAppBusinessProfile whatsAppBusinessProfile = (WhatsAppBusinessProfile)WhatsAppBusinessProfile.getGson().fromJson(json, WhatsAppBusinessProfile.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(whatsAppBusinessProfile.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        whatsAppBusinessProfile.context = context;
        whatsAppBusinessProfile.rawValue = json;
        whatsAppBusinessProfile.header = header;
        return whatsAppBusinessProfile;
    }

    public static APINodeList<WhatsAppBusinessProfile> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WhatsAppBusinessProfile> whatsAppBusinessProfiles = new APINodeList<WhatsAppBusinessProfile>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return whatsAppBusinessProfiles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            whatsAppBusinessProfiles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        whatsAppBusinessProfiles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            whatsAppBusinessProfiles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return whatsAppBusinessProfiles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return whatsAppBusinessProfiles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return whatsAppBusinessProfiles;
                }
                whatsAppBusinessProfiles.clear();
                whatsAppBusinessProfiles.add(WhatsAppBusinessProfile.loadJSON(json, context, header));
                return whatsAppBusinessProfiles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WhatsAppBusinessProfile.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldNameVerification() {
        return this.mNameVerification;
    }

    public String getFieldVerifiedName() {
        return this.mVerifiedName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WhatsAppBusinessProfile copyFrom(WhatsAppBusinessProfile instance) {
        this.mId = instance.mId;
        this.mNameVerification = instance.mNameVerification;
        this.mVerifiedName = instance.mVerifiedName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WhatsAppBusinessProfile> getParser() {
        return new APIRequest.ResponseParser<WhatsAppBusinessProfile>(){

            @Override
            public APINodeList<WhatsAppBusinessProfile> parseResponse(String response, APIContext context, APIRequest<WhatsAppBusinessProfile> request, String header) throws APIException.MalformedResponseException {
                return WhatsAppBusinessProfile.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<WhatsAppBusinessProfile> {
        WhatsAppBusinessProfile lastResponse = null;
        public static final String[] PARAMS = new String[]{"verified_name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessProfile getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessProfile parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessProfile.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessProfile execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessProfile execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessProfile> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessProfile> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessProfile>(){

                public WhatsAppBusinessProfile apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setVerifiedName(String verifiedName) {
            this.setParam("verified_name", verifiedName);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<WhatsAppBusinessProfile> {
        WhatsAppBusinessProfile lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name_verification", "verified_name"};

        @Override
        public WhatsAppBusinessProfile getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessProfile parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessProfile.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessProfile execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessProfile execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessProfile> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessProfile> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessProfile>(){

                public WhatsAppBusinessProfile apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameVerificationField() {
            return this.requestNameVerificationField(true);
        }

        public APIRequestGet requestNameVerificationField(boolean value) {
            this.requestField("name_verification", value);
            return this;
        }

        public APIRequestGet requestVerifiedNameField() {
            return this.requestVerifiedNameField(true);
        }

        public APIRequestGet requestVerifiedNameField(boolean value) {
            this.requestField("verified_name", value);
            return this;
        }
    }
}

