/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterativeSplitTestConfig
extends APINode {
    @SerializedName(value="budget")
    private Long mBudget = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="guidance")
    private Object mGuidance = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="iterative_split_test_original_variant_id")
    private String mIterativeSplitTestOriginalVariantId = null;
    @SerializedName(value="iterative_split_test_variant_to_split_mapping")
    private Map<String, Long> mIterativeSplitTestVariantToSplitMapping = null;
    @SerializedName(value="results_window")
    private Object mResultsWindow = null;
    @SerializedName(value="splits")
    private List<Long> mSplits = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    protected static Gson gson = null;

    IterativeSplitTestConfig() {
    }

    public IterativeSplitTestConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public IterativeSplitTestConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public IterativeSplitTestConfig fetch() throws APIException {
        IterativeSplitTestConfig newInstance = IterativeSplitTestConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static IterativeSplitTestConfig fetchById(Long id, APIContext context) throws APIException {
        return IterativeSplitTestConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<IterativeSplitTestConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return IterativeSplitTestConfig.fetchByIdAsync(id.toString(), context);
    }

    public static IterativeSplitTestConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<IterativeSplitTestConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<IterativeSplitTestConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<IterativeSplitTestConfig>(context, "", "/", "GET", IterativeSplitTestConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<IterativeSplitTestConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<IterativeSplitTestConfig>(context, "", "/", "GET", IterativeSplitTestConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static IterativeSplitTestConfig loadJSON(String json, APIContext context, String header) {
        IterativeSplitTestConfig iterativeSplitTestConfig = (IterativeSplitTestConfig)IterativeSplitTestConfig.getGson().fromJson(json, IterativeSplitTestConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(iterativeSplitTestConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        iterativeSplitTestConfig.context = context;
        iterativeSplitTestConfig.rawValue = json;
        iterativeSplitTestConfig.header = header;
        return iterativeSplitTestConfig;
    }

    public static APINodeList<IterativeSplitTestConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<IterativeSplitTestConfig> iterativeSplitTestConfigs = new APINodeList<IterativeSplitTestConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return iterativeSplitTestConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            iterativeSplitTestConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        iterativeSplitTestConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            iterativeSplitTestConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return iterativeSplitTestConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return iterativeSplitTestConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return iterativeSplitTestConfigs;
                }
                iterativeSplitTestConfigs.clear();
                iterativeSplitTestConfigs.add(IterativeSplitTestConfig.loadJSON(json, context, header));
                return iterativeSplitTestConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return IterativeSplitTestConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldBudget() {
        return this.mBudget;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Object getFieldGuidance() {
        return this.mGuidance;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIterativeSplitTestOriginalVariantId() {
        return this.mIterativeSplitTestOriginalVariantId;
    }

    public Map<String, Long> getFieldIterativeSplitTestVariantToSplitMapping() {
        return this.mIterativeSplitTestVariantToSplitMapping;
    }

    public Object getFieldResultsWindow() {
        return this.mResultsWindow;
    }

    public List<Long> getFieldSplits() {
        return this.mSplits;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public IterativeSplitTestConfig copyFrom(IterativeSplitTestConfig instance) {
        this.mBudget = instance.mBudget;
        this.mEndTime = instance.mEndTime;
        this.mGuidance = instance.mGuidance;
        this.mId = instance.mId;
        this.mIterativeSplitTestOriginalVariantId = instance.mIterativeSplitTestOriginalVariantId;
        this.mIterativeSplitTestVariantToSplitMapping = instance.mIterativeSplitTestVariantToSplitMapping;
        this.mResultsWindow = instance.mResultsWindow;
        this.mSplits = instance.mSplits;
        this.mStartTime = instance.mStartTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<IterativeSplitTestConfig> getParser() {
        return new APIRequest.ResponseParser<IterativeSplitTestConfig>(){

            @Override
            public APINodeList<IterativeSplitTestConfig> parseResponse(String response, APIContext context, APIRequest<IterativeSplitTestConfig> request, String header) throws APIException.MalformedResponseException {
                return IterativeSplitTestConfig.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<IterativeSplitTestConfig> {
        IterativeSplitTestConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"budget", "end_time", "guidance", "id", "iterative_split_test_original_variant_id", "iterative_split_test_variant_to_split_mapping", "results_window", "splits", "start_time"};

        @Override
        public IterativeSplitTestConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public IterativeSplitTestConfig parseResponse(String response, String header) throws APIException {
            return IterativeSplitTestConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public IterativeSplitTestConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public IterativeSplitTestConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<IterativeSplitTestConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<IterativeSplitTestConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, IterativeSplitTestConfig>(){

                public IterativeSplitTestConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBudgetField() {
            return this.requestBudgetField(true);
        }

        public APIRequestGet requestBudgetField(boolean value) {
            this.requestField("budget", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestGuidanceField() {
            return this.requestGuidanceField(true);
        }

        public APIRequestGet requestGuidanceField(boolean value) {
            this.requestField("guidance", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIterativeSplitTestOriginalVariantIdField() {
            return this.requestIterativeSplitTestOriginalVariantIdField(true);
        }

        public APIRequestGet requestIterativeSplitTestOriginalVariantIdField(boolean value) {
            this.requestField("iterative_split_test_original_variant_id", value);
            return this;
        }

        public APIRequestGet requestIterativeSplitTestVariantToSplitMappingField() {
            return this.requestIterativeSplitTestVariantToSplitMappingField(true);
        }

        public APIRequestGet requestIterativeSplitTestVariantToSplitMappingField(boolean value) {
            this.requestField("iterative_split_test_variant_to_split_mapping", value);
            return this;
        }

        public APIRequestGet requestResultsWindowField() {
            return this.requestResultsWindowField(true);
        }

        public APIRequestGet requestResultsWindowField(boolean value) {
            this.requestField("results_window", value);
            return this;
        }

        public APIRequestGet requestSplitsField() {
            return this.requestSplitsField(true);
        }

        public APIRequestGet requestSplitsField(boolean value) {
            this.requestField("splits", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }
    }
}

