/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataImageOverlaySpec
extends APINode {
    @SerializedName(value="custom_text_type")
    private EnumCustomTextType mCustomTextType = null;
    @SerializedName(value="float_with_margin")
    private Boolean mFloatWithMargin = null;
    @SerializedName(value="overlay_template")
    private EnumOverlayTemplate mOverlayTemplate = null;
    @SerializedName(value="position")
    private EnumPosition mPosition = null;
    @SerializedName(value="text_font")
    private EnumTextFont mTextFont = null;
    @SerializedName(value="text_template_tags")
    private List<String> mTextTemplateTags = null;
    @SerializedName(value="text_type")
    private EnumTextType mTextType = null;
    @SerializedName(value="theme_color")
    private EnumThemeColor mThemeColor = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeLinkDataImageOverlaySpec loadJSON(String json, APIContext context, String header) {
        AdCreativeLinkDataImageOverlaySpec adCreativeLinkDataImageOverlaySpec = (AdCreativeLinkDataImageOverlaySpec)AdCreativeLinkDataImageOverlaySpec.getGson().fromJson(json, AdCreativeLinkDataImageOverlaySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataImageOverlaySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataImageOverlaySpec.context = context;
        adCreativeLinkDataImageOverlaySpec.rawValue = json;
        adCreativeLinkDataImageOverlaySpec.header = header;
        return adCreativeLinkDataImageOverlaySpec;
    }

    public static APINodeList<AdCreativeLinkDataImageOverlaySpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataImageOverlaySpec> adCreativeLinkDataImageOverlaySpecs = new APINodeList<AdCreativeLinkDataImageOverlaySpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeLinkDataImageOverlaySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataImageOverlaySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataImageOverlaySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataImageOverlaySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeLinkDataImageOverlaySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeLinkDataImageOverlaySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataImageOverlaySpecs;
                }
                adCreativeLinkDataImageOverlaySpecs.clear();
                adCreativeLinkDataImageOverlaySpecs.add(AdCreativeLinkDataImageOverlaySpec.loadJSON(json, context, header));
                return adCreativeLinkDataImageOverlaySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataImageOverlaySpec.getGson().toJson((Object)this);
    }

    public EnumCustomTextType getFieldCustomTextType() {
        return this.mCustomTextType;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldCustomTextType(EnumCustomTextType value) {
        this.mCustomTextType = value;
        return this;
    }

    public Boolean getFieldFloatWithMargin() {
        return this.mFloatWithMargin;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldFloatWithMargin(Boolean value) {
        this.mFloatWithMargin = value;
        return this;
    }

    public EnumOverlayTemplate getFieldOverlayTemplate() {
        return this.mOverlayTemplate;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldOverlayTemplate(EnumOverlayTemplate value) {
        this.mOverlayTemplate = value;
        return this;
    }

    public EnumPosition getFieldPosition() {
        return this.mPosition;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldPosition(EnumPosition value) {
        this.mPosition = value;
        return this;
    }

    public EnumTextFont getFieldTextFont() {
        return this.mTextFont;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldTextFont(EnumTextFont value) {
        this.mTextFont = value;
        return this;
    }

    public List<String> getFieldTextTemplateTags() {
        return this.mTextTemplateTags;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldTextTemplateTags(List<String> value) {
        this.mTextTemplateTags = value;
        return this;
    }

    public EnumTextType getFieldTextType() {
        return this.mTextType;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldTextType(EnumTextType value) {
        this.mTextType = value;
        return this;
    }

    public EnumThemeColor getFieldThemeColor() {
        return this.mThemeColor;
    }

    public AdCreativeLinkDataImageOverlaySpec setFieldThemeColor(EnumThemeColor value) {
        this.mThemeColor = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataImageOverlaySpec copyFrom(AdCreativeLinkDataImageOverlaySpec instance) {
        this.mCustomTextType = instance.mCustomTextType;
        this.mFloatWithMargin = instance.mFloatWithMargin;
        this.mOverlayTemplate = instance.mOverlayTemplate;
        this.mPosition = instance.mPosition;
        this.mTextFont = instance.mTextFont;
        this.mTextTemplateTags = instance.mTextTemplateTags;
        this.mTextType = instance.mTextType;
        this.mThemeColor = instance.mThemeColor;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataImageOverlaySpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataImageOverlaySpec>(){

            @Override
            public APINodeList<AdCreativeLinkDataImageOverlaySpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataImageOverlaySpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataImageOverlaySpec.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumThemeColor {
        VALUE_BACKGROUND_000000_TEXT_FFFFFF("background_000000_text_ffffff"),
        VALUE_BACKGROUND_0090FF_TEXT_FFFFFF("background_0090ff_text_ffffff"),
        VALUE_BACKGROUND_00AF4C_TEXT_FFFFFF("background_00af4c_text_ffffff"),
        VALUE_BACKGROUND_595959_TEXT_FFFFFF("background_595959_text_ffffff"),
        VALUE_BACKGROUND_755DDE_TEXT_FFFFFF("background_755dde_text_ffffff"),
        VALUE_BACKGROUND_E50900_TEXT_FFFFFF("background_e50900_text_ffffff"),
        VALUE_BACKGROUND_F23474_TEXT_FFFFFF("background_f23474_text_ffffff"),
        VALUE_BACKGROUND_F78400_TEXT_FFFFFF("background_f78400_text_ffffff"),
        VALUE_BACKGROUND_FFFFFF_TEXT_000000("background_ffffff_text_000000"),
        VALUE_BACKGROUND_FFFFFF_TEXT_007AD0("background_ffffff_text_007ad0"),
        VALUE_BACKGROUND_FFFFFF_TEXT_009C2A("background_ffffff_text_009c2a"),
        VALUE_BACKGROUND_FFFFFF_TEXT_646464("background_ffffff_text_646464"),
        VALUE_BACKGROUND_FFFFFF_TEXT_755DDE("background_ffffff_text_755dde"),
        VALUE_BACKGROUND_FFFFFF_TEXT_C91B00("background_ffffff_text_c91b00"),
        VALUE_BACKGROUND_FFFFFF_TEXT_F23474("background_ffffff_text_f23474"),
        VALUE_BACKGROUND_FFFFFF_TEXT_F78400("background_ffffff_text_f78400"),
        NULL(null);

        private String value;

        private EnumThemeColor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTextType {
        VALUE_CUSTOM("custom"),
        VALUE_DISCLAIMER("disclaimer"),
        VALUE_FROM_PRICE("from_price"),
        VALUE_PERCENTAGE_OFF("percentage_off"),
        VALUE_PRICE("price"),
        VALUE_STRIKETHROUGH_PRICE("strikethrough_price"),
        NULL(null);

        private String value;

        private EnumTextType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTextFont {
        VALUE_DROID_SERIF_REGULAR("droid_serif_regular"),
        VALUE_DYNADS_HYBRID_BOLD("dynads_hybrid_bold"),
        VALUE_LATO_REGULAR("lato_regular"),
        VALUE_NOTO_SANS_REGULAR("noto_sans_regular"),
        VALUE_NUNITO_SANS_BOLD("nunito_sans_bold"),
        VALUE_OPEN_SANS_BOLD("open_sans_bold"),
        VALUE_OPEN_SANS_CONDENSED_BOLD("open_sans_condensed_bold"),
        VALUE_PT_SERIF_BOLD("pt_serif_bold"),
        VALUE_ROBOTO_CONDENSED_REGULAR("roboto_condensed_regular"),
        VALUE_ROBOTO_MEDIUM("roboto_medium"),
        NULL(null);

        private String value;

        private EnumTextFont(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPosition {
        VALUE_BOTTOM_LEFT("bottom_left"),
        VALUE_BOTTOM_RIGHT("bottom_right"),
        VALUE_TOP_LEFT("top_left"),
        VALUE_TOP_RIGHT("top_right"),
        NULL(null);

        private String value;

        private EnumPosition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOverlayTemplate {
        VALUE_CIRCLE_WITH_TEXT("circle_with_text"),
        VALUE_PILL_WITH_TEXT("pill_with_text"),
        VALUE_TRIANGLE_WITH_TEXT("triangle_with_text"),
        NULL(null);

        private String value;

        private EnumOverlayTemplate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCustomTextType {
        VALUE_FREE_SHIPPING("free_shipping"),
        NULL(null);

        private String value;

        private EnumCustomTextType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

