/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Engagement;
import com.facebook.ads.sdk.Location;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenGraphObject
extends APINode {
    @SerializedName(value="admins")
    private List<Object> mAdmins = null;
    @SerializedName(value="application")
    private Object mApplication = null;
    @SerializedName(value="audio")
    private List<Object> mAudio = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="determiner")
    private String mDeterminer = null;
    @SerializedName(value="engagement")
    private Engagement mEngagement = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image")
    private List<Object> mImage = null;
    @SerializedName(value="is_scraped")
    private Boolean mIsScraped = null;
    @SerializedName(value="locale")
    private Object mLocale = null;
    @SerializedName(value="location")
    private Location mLocation = null;
    @SerializedName(value="post_action_id")
    private String mPostActionId = null;
    @SerializedName(value="profile_id")
    private Object mProfileId = null;
    @SerializedName(value="restrictions")
    private Object mRestrictions = null;
    @SerializedName(value="see_also")
    private List<String> mSeeAlso = null;
    @SerializedName(value="site_name")
    private String mSiteName = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="video")
    private List<Object> mVideo = null;
    protected static Gson gson = null;

    OpenGraphObject() {
    }

    public OpenGraphObject(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OpenGraphObject(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OpenGraphObject fetch() throws APIException {
        OpenGraphObject newInstance = OpenGraphObject.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OpenGraphObject fetchById(Long id, APIContext context) throws APIException {
        return OpenGraphObject.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OpenGraphObject> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OpenGraphObject.fetchByIdAsync(id.toString(), context);
    }

    public static OpenGraphObject fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OpenGraphObject> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OpenGraphObject> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OpenGraphObject>(context, "", "/", "GET", OpenGraphObject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OpenGraphObject>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OpenGraphObject>(context, "", "/", "GET", OpenGraphObject.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OpenGraphObject loadJSON(String json, APIContext context, String header) {
        OpenGraphObject openGraphObject = (OpenGraphObject)OpenGraphObject.getGson().fromJson(json, OpenGraphObject.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(openGraphObject.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        openGraphObject.context = context;
        openGraphObject.rawValue = json;
        openGraphObject.header = header;
        return openGraphObject;
    }

    public static APINodeList<OpenGraphObject> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OpenGraphObject> openGraphObjects = new APINodeList<OpenGraphObject>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        openGraphObjects.add(OpenGraphObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return openGraphObjects;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            openGraphObjects.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        openGraphObjects.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            openGraphObjects.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            openGraphObjects.add(OpenGraphObject.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                openGraphObjects.add(OpenGraphObject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            openGraphObjects.add(OpenGraphObject.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return openGraphObjects;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        openGraphObjects.add(OpenGraphObject.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return openGraphObjects;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        openGraphObjects.add(OpenGraphObject.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return openGraphObjects;
                }
                openGraphObjects.clear();
                openGraphObjects.add(OpenGraphObject.loadJSON(json, context, header));
                return openGraphObjects;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OpenGraphObject.getGson().toJson((Object)this);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Object> getFieldAdmins() {
        return this.mAdmins;
    }

    public Object getFieldApplication() {
        return this.mApplication;
    }

    public List<Object> getFieldAudio() {
        return this.mAudio;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDeterminer() {
        return this.mDeterminer;
    }

    public Engagement getFieldEngagement() {
        return this.mEngagement;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Object> getFieldImage() {
        return this.mImage;
    }

    public Boolean getFieldIsScraped() {
        return this.mIsScraped;
    }

    public Object getFieldLocale() {
        return this.mLocale;
    }

    public Location getFieldLocation() {
        return this.mLocation;
    }

    public String getFieldPostActionId() {
        return this.mPostActionId;
    }

    public Object getFieldProfileId() {
        return this.mProfileId;
    }

    public Object getFieldRestrictions() {
        return this.mRestrictions;
    }

    public List<String> getFieldSeeAlso() {
        return this.mSeeAlso;
    }

    public String getFieldSiteName() {
        return this.mSiteName;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public List<Object> getFieldVideo() {
        return this.mVideo;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OpenGraphObject copyFrom(OpenGraphObject instance) {
        this.mAdmins = instance.mAdmins;
        this.mApplication = instance.mApplication;
        this.mAudio = instance.mAudio;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mDeterminer = instance.mDeterminer;
        this.mEngagement = instance.mEngagement;
        this.mId = instance.mId;
        this.mImage = instance.mImage;
        this.mIsScraped = instance.mIsScraped;
        this.mLocale = instance.mLocale;
        this.mLocation = instance.mLocation;
        this.mPostActionId = instance.mPostActionId;
        this.mProfileId = instance.mProfileId;
        this.mRestrictions = instance.mRestrictions;
        this.mSeeAlso = instance.mSeeAlso;
        this.mSiteName = instance.mSiteName;
        this.mTitle = instance.mTitle;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVideo = instance.mVideo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OpenGraphObject> getParser() {
        return new APIRequest.ResponseParser<OpenGraphObject>(){

            @Override
            public APINodeList<OpenGraphObject> parseResponse(String response, APIContext context, APIRequest<OpenGraphObject> request, String header) throws APIException.MalformedResponseException {
                return OpenGraphObject.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<OpenGraphObject> {
        OpenGraphObject lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"admins", "application", "audio", "created_time", "description", "determiner", "engagement", "id", "image", "is_scraped", "locale", "location", "post_action_id", "profile_id", "restrictions", "see_also", "site_name", "title", "type", "updated_time", "video"};

        @Override
        public OpenGraphObject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OpenGraphObject parseResponse(String response, String header) throws APIException {
            return OpenGraphObject.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OpenGraphObject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OpenGraphObject execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OpenGraphObject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OpenGraphObject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OpenGraphObject>(){

                public OpenGraphObject apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdminsField() {
            return this.requestAdminsField(true);
        }

        public APIRequestGet requestAdminsField(boolean value) {
            this.requestField("admins", value);
            return this;
        }

        public APIRequestGet requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGet requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGet requestAudioField() {
            return this.requestAudioField(true);
        }

        public APIRequestGet requestAudioField(boolean value) {
            this.requestField("audio", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDeterminerField() {
            return this.requestDeterminerField(true);
        }

        public APIRequestGet requestDeterminerField(boolean value) {
            this.requestField("determiner", value);
            return this;
        }

        public APIRequestGet requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGet requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageField() {
            return this.requestImageField(true);
        }

        public APIRequestGet requestImageField(boolean value) {
            this.requestField("image", value);
            return this;
        }

        public APIRequestGet requestIsScrapedField() {
            return this.requestIsScrapedField(true);
        }

        public APIRequestGet requestIsScrapedField(boolean value) {
            this.requestField("is_scraped", value);
            return this;
        }

        public APIRequestGet requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGet requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestPostActionIdField() {
            return this.requestPostActionIdField(true);
        }

        public APIRequestGet requestPostActionIdField(boolean value) {
            this.requestField("post_action_id", value);
            return this;
        }

        public APIRequestGet requestProfileIdField() {
            return this.requestProfileIdField(true);
        }

        public APIRequestGet requestProfileIdField(boolean value) {
            this.requestField("profile_id", value);
            return this;
        }

        public APIRequestGet requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGet requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGet requestSeeAlsoField() {
            return this.requestSeeAlsoField(true);
        }

        public APIRequestGet requestSeeAlsoField(boolean value) {
            this.requestField("see_also", value);
            return this;
        }

        public APIRequestGet requestSiteNameField() {
            return this.requestSiteNameField(true);
        }

        public APIRequestGet requestSiteNameField(boolean value) {
            this.requestField("site_name", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGet requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"redirect", "type"};
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "url", "width"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response, String header) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProfilePictureSource>>(){

                public APINodeList<ProfilePictureSource> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPicture.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGetPicture requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }
}

