/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeOptimizationSpec
extends APINode {
    @SerializedName(value="bodies")
    private List<String> mBodies = null;
    @SerializedName(value="descriptions")
    private List<String> mDescriptions = null;
    @SerializedName(value="titles")
    private List<String> mTitles = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeOptimizationSpec loadJSON(String json, APIContext context, String header) {
        AdCreativeOptimizationSpec adCreativeOptimizationSpec = (AdCreativeOptimizationSpec)AdCreativeOptimizationSpec.getGson().fromJson(json, AdCreativeOptimizationSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeOptimizationSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeOptimizationSpec.context = context;
        adCreativeOptimizationSpec.rawValue = json;
        adCreativeOptimizationSpec.header = header;
        return adCreativeOptimizationSpec;
    }

    public static APINodeList<AdCreativeOptimizationSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeOptimizationSpec> adCreativeOptimizationSpecs = new APINodeList<AdCreativeOptimizationSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeOptimizationSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeOptimizationSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeOptimizationSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeOptimizationSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeOptimizationSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeOptimizationSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeOptimizationSpecs;
                }
                adCreativeOptimizationSpecs.clear();
                adCreativeOptimizationSpecs.add(AdCreativeOptimizationSpec.loadJSON(json, context, header));
                return adCreativeOptimizationSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeOptimizationSpec.getGson().toJson((Object)this);
    }

    public List<String> getFieldBodies() {
        return this.mBodies;
    }

    public AdCreativeOptimizationSpec setFieldBodies(List<String> value) {
        this.mBodies = value;
        return this;
    }

    public List<String> getFieldDescriptions() {
        return this.mDescriptions;
    }

    public AdCreativeOptimizationSpec setFieldDescriptions(List<String> value) {
        this.mDescriptions = value;
        return this;
    }

    public List<String> getFieldTitles() {
        return this.mTitles;
    }

    public AdCreativeOptimizationSpec setFieldTitles(List<String> value) {
        this.mTitles = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeOptimizationSpec copyFrom(AdCreativeOptimizationSpec instance) {
        this.mBodies = instance.mBodies;
        this.mDescriptions = instance.mDescriptions;
        this.mTitles = instance.mTitles;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeOptimizationSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeOptimizationSpec>(){

            @Override
            public APINodeList<AdCreativeOptimizationSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeOptimizationSpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeOptimizationSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

