/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LeadGenDraftQuestion;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenDataDraft
extends APINode {
    @SerializedName(value="block_display_for_non_targeted_viewer")
    private Boolean mBlockDisplayForNonTargetedViewer = null;
    @SerializedName(value="context_card")
    private Object mContextCard = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="creator_id")
    private String mCreatorId = null;
    @SerializedName(value="follow_up_action_url")
    private String mFollowUpActionUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_optimized_for_quality")
    private Boolean mIsOptimizedForQuality = null;
    @SerializedName(value="legal_content")
    private Object mLegalContent = null;
    @SerializedName(value="locale")
    private String mLocale = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="question_page_custom_headline")
    private String mQuestionPageCustomHeadline = null;
    @SerializedName(value="questions")
    private List<LeadGenDraftQuestion> mQuestions = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="thank_you_page")
    private Object mThankYouPage = null;
    @SerializedName(value="tracking_parameters")
    private Map<String, String> mTrackingParameters = null;
    protected static Gson gson = null;

    LeadGenDataDraft() {
    }

    public LeadGenDataDraft(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LeadGenDataDraft(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LeadGenDataDraft fetch() throws APIException {
        LeadGenDataDraft newInstance = LeadGenDataDraft.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LeadGenDataDraft fetchById(Long id, APIContext context) throws APIException {
        return LeadGenDataDraft.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LeadGenDataDraft> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LeadGenDataDraft.fetchByIdAsync(id.toString(), context);
    }

    public static LeadGenDataDraft fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LeadGenDataDraft> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LeadGenDataDraft> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LeadGenDataDraft>(context, "", "/", "GET", LeadGenDataDraft.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LeadGenDataDraft>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LeadGenDataDraft>(context, "", "/", "GET", LeadGenDataDraft.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenDataDraft loadJSON(String json, APIContext context, String header) {
        LeadGenDataDraft leadGenDataDraft = (LeadGenDataDraft)LeadGenDataDraft.getGson().fromJson(json, LeadGenDataDraft.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenDataDraft.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenDataDraft.context = context;
        leadGenDataDraft.rawValue = json;
        leadGenDataDraft.header = header;
        return leadGenDataDraft;
    }

    public static APINodeList<LeadGenDataDraft> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenDataDraft> leadGenDataDrafts = new APINodeList<LeadGenDataDraft>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return leadGenDataDrafts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenDataDrafts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenDataDrafts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenDataDrafts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return leadGenDataDrafts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return leadGenDataDrafts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenDataDrafts;
                }
                leadGenDataDrafts.clear();
                leadGenDataDrafts.add(LeadGenDataDraft.loadJSON(json, context, header));
                return leadGenDataDrafts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenDataDraft.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldBlockDisplayForNonTargetedViewer() {
        return this.mBlockDisplayForNonTargetedViewer;
    }

    public Object getFieldContextCard() {
        return this.mContextCard;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldCreatorId() {
        return this.mCreatorId;
    }

    public String getFieldFollowUpActionUrl() {
        return this.mFollowUpActionUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsOptimizedForQuality() {
        return this.mIsOptimizedForQuality;
    }

    public Object getFieldLegalContent() {
        return this.mLegalContent;
    }

    public String getFieldLocale() {
        return this.mLocale;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public String getFieldQuestionPageCustomHeadline() {
        return this.mQuestionPageCustomHeadline;
    }

    public List<LeadGenDraftQuestion> getFieldQuestions() {
        return this.mQuestions;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Object getFieldThankYouPage() {
        return this.mThankYouPage;
    }

    public Map<String, String> getFieldTrackingParameters() {
        return this.mTrackingParameters;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenDataDraft copyFrom(LeadGenDataDraft instance) {
        this.mBlockDisplayForNonTargetedViewer = instance.mBlockDisplayForNonTargetedViewer;
        this.mContextCard = instance.mContextCard;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCreatorId = instance.mCreatorId;
        this.mFollowUpActionUrl = instance.mFollowUpActionUrl;
        this.mId = instance.mId;
        this.mIsOptimizedForQuality = instance.mIsOptimizedForQuality;
        this.mLegalContent = instance.mLegalContent;
        this.mLocale = instance.mLocale;
        this.mName = instance.mName;
        this.mPage = instance.mPage;
        this.mQuestionPageCustomHeadline = instance.mQuestionPageCustomHeadline;
        this.mQuestions = instance.mQuestions;
        this.mStatus = instance.mStatus;
        this.mThankYouPage = instance.mThankYouPage;
        this.mTrackingParameters = instance.mTrackingParameters;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenDataDraft> getParser() {
        return new APIRequest.ResponseParser<LeadGenDataDraft>(){

            @Override
            public APINodeList<LeadGenDataDraft> parseResponse(String response, APIContext context, APIRequest<LeadGenDataDraft> request, String header) throws APIException.MalformedResponseException {
                return LeadGenDataDraft.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_DRAFT("DRAFT"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLocale {
        VALUE_AR_AR("AR_AR"),
        VALUE_CS_CZ("CS_CZ"),
        VALUE_DA_DK("DA_DK"),
        VALUE_DE_DE("DE_DE"),
        VALUE_EN_GB("EN_GB"),
        VALUE_EN_US("EN_US"),
        VALUE_ES_ES("ES_ES"),
        VALUE_ES_LA("ES_LA"),
        VALUE_FI_FI("FI_FI"),
        VALUE_FR_FR("FR_FR"),
        VALUE_HE_IL("HE_IL"),
        VALUE_HI_IN("HI_IN"),
        VALUE_HU_HU("HU_HU"),
        VALUE_ID_ID("ID_ID"),
        VALUE_IT_IT("IT_IT"),
        VALUE_JA_JP("JA_JP"),
        VALUE_KO_KR("KO_KR"),
        VALUE_NB_NO("NB_NO"),
        VALUE_NL_NL("NL_NL"),
        VALUE_PL_PL("PL_PL"),
        VALUE_PT_BR("PT_BR"),
        VALUE_PT_PT("PT_PT"),
        VALUE_RO_RO("RO_RO"),
        VALUE_RU_RU("RU_RU"),
        VALUE_SV_SE("SV_SE"),
        VALUE_TH_TH("TH_TH"),
        VALUE_TR_TR("TR_TR"),
        VALUE_VI_VN("VI_VN"),
        VALUE_ZH_CN("ZH_CN"),
        VALUE_ZH_HK("ZH_HK"),
        VALUE_ZH_TW("ZH_TW"),
        NULL(null);

        private String value;

        private EnumLocale(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<LeadGenDataDraft> {
        LeadGenDataDraft lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "locale", "block_display_for_non_targeted_viewer", "follow_up_action_url", "legal_content_id", "context_card_id", "questions", "privacy_policy", "custom_disclaimer", "context_card", "thank_you_page", "tracking_parameters", "question_page_custom_headline", "is_optimized_for_quality", "status", "delete_missing_parameters"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LeadGenDataDraft getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenDataDraft parseResponse(String response, String header) throws APIException {
            return LeadGenDataDraft.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LeadGenDataDraft execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenDataDraft execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenDataDraft> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenDataDraft> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LeadGenDataDraft>(){

                public LeadGenDataDraft apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setLocale(EnumLocale locale) {
            this.setParam("locale", (Object)locale);
            return this;
        }

        public APIRequestUpdate setLocale(String locale) {
            this.setParam("locale", locale);
            return this;
        }

        public APIRequestUpdate setBlockDisplayForNonTargetedViewer(Boolean blockDisplayForNonTargetedViewer) {
            this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
            return this;
        }

        public APIRequestUpdate setBlockDisplayForNonTargetedViewer(String blockDisplayForNonTargetedViewer) {
            this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
            return this;
        }

        public APIRequestUpdate setFollowUpActionUrl(String followUpActionUrl) {
            this.setParam("follow_up_action_url", followUpActionUrl);
            return this;
        }

        public APIRequestUpdate setLegalContentId(String legalContentId) {
            this.setParam("legal_content_id", legalContentId);
            return this;
        }

        public APIRequestUpdate setContextCardId(String contextCardId) {
            this.setParam("context_card_id", contextCardId);
            return this;
        }

        public APIRequestUpdate setQuestions(List<Object> questions) {
            this.setParam("questions", questions);
            return this;
        }

        public APIRequestUpdate setQuestions(String questions) {
            this.setParam("questions", questions);
            return this;
        }

        public APIRequestUpdate setPrivacyPolicy(Map<String, String> privacyPolicy) {
            this.setParam("privacy_policy", privacyPolicy);
            return this;
        }

        public APIRequestUpdate setPrivacyPolicy(String privacyPolicy) {
            this.setParam("privacy_policy", privacyPolicy);
            return this;
        }

        public APIRequestUpdate setCustomDisclaimer(Object customDisclaimer) {
            this.setParam("custom_disclaimer", customDisclaimer);
            return this;
        }

        public APIRequestUpdate setCustomDisclaimer(String customDisclaimer) {
            this.setParam("custom_disclaimer", customDisclaimer);
            return this;
        }

        public APIRequestUpdate setContextCard(Object contextCard) {
            this.setParam("context_card", contextCard);
            return this;
        }

        public APIRequestUpdate setContextCard(String contextCard) {
            this.setParam("context_card", contextCard);
            return this;
        }

        public APIRequestUpdate setThankYouPage(Map<String, String> thankYouPage) {
            this.setParam("thank_you_page", thankYouPage);
            return this;
        }

        public APIRequestUpdate setThankYouPage(String thankYouPage) {
            this.setParam("thank_you_page", thankYouPage);
            return this;
        }

        public APIRequestUpdate setTrackingParameters(Map<String, String> trackingParameters) {
            this.setParam("tracking_parameters", trackingParameters);
            return this;
        }

        public APIRequestUpdate setTrackingParameters(String trackingParameters) {
            this.setParam("tracking_parameters", trackingParameters);
            return this;
        }

        public APIRequestUpdate setQuestionPageCustomHeadline(String questionPageCustomHeadline) {
            this.setParam("question_page_custom_headline", questionPageCustomHeadline);
            return this;
        }

        public APIRequestUpdate setIsOptimizedForQuality(Boolean isOptimizedForQuality) {
            this.setParam("is_optimized_for_quality", isOptimizedForQuality);
            return this;
        }

        public APIRequestUpdate setIsOptimizedForQuality(String isOptimizedForQuality) {
            this.setParam("is_optimized_for_quality", isOptimizedForQuality);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate setDeleteMissingParameters(Boolean deleteMissingParameters) {
            this.setParam("delete_missing_parameters", deleteMissingParameters);
            return this;
        }

        public APIRequestUpdate setDeleteMissingParameters(String deleteMissingParameters) {
            this.setParam("delete_missing_parameters", deleteMissingParameters);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LeadGenDataDraft> {
        LeadGenDataDraft lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_display_for_non_targeted_viewer", "context_card", "created_time", "creator_id", "follow_up_action_url", "id", "is_optimized_for_quality", "legal_content", "locale", "name", "page", "question_page_custom_headline", "questions", "status", "thank_you_page", "tracking_parameters"};

        @Override
        public LeadGenDataDraft getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenDataDraft parseResponse(String response, String header) throws APIException {
            return LeadGenDataDraft.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LeadGenDataDraft execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenDataDraft execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenDataDraft> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenDataDraft> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LeadGenDataDraft>(){

                public LeadGenDataDraft apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBlockDisplayForNonTargetedViewerField() {
            return this.requestBlockDisplayForNonTargetedViewerField(true);
        }

        public APIRequestGet requestBlockDisplayForNonTargetedViewerField(boolean value) {
            this.requestField("block_display_for_non_targeted_viewer", value);
            return this;
        }

        public APIRequestGet requestContextCardField() {
            return this.requestContextCardField(true);
        }

        public APIRequestGet requestContextCardField(boolean value) {
            this.requestField("context_card", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCreatorIdField() {
            return this.requestCreatorIdField(true);
        }

        public APIRequestGet requestCreatorIdField(boolean value) {
            this.requestField("creator_id", value);
            return this;
        }

        public APIRequestGet requestFollowUpActionUrlField() {
            return this.requestFollowUpActionUrlField(true);
        }

        public APIRequestGet requestFollowUpActionUrlField(boolean value) {
            this.requestField("follow_up_action_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsOptimizedForQualityField() {
            return this.requestIsOptimizedForQualityField(true);
        }

        public APIRequestGet requestIsOptimizedForQualityField(boolean value) {
            this.requestField("is_optimized_for_quality", value);
            return this;
        }

        public APIRequestGet requestLegalContentField() {
            return this.requestLegalContentField(true);
        }

        public APIRequestGet requestLegalContentField(boolean value) {
            this.requestField("legal_content", value);
            return this;
        }

        public APIRequestGet requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGet requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestQuestionPageCustomHeadlineField() {
            return this.requestQuestionPageCustomHeadlineField(true);
        }

        public APIRequestGet requestQuestionPageCustomHeadlineField(boolean value) {
            this.requestField("question_page_custom_headline", value);
            return this;
        }

        public APIRequestGet requestQuestionsField() {
            return this.requestQuestionsField(true);
        }

        public APIRequestGet requestQuestionsField(boolean value) {
            this.requestField("questions", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestThankYouPageField() {
            return this.requestThankYouPageField(true);
        }

        public APIRequestGet requestThankYouPageField(boolean value) {
            this.requestField("thank_you_page", value);
            return this;
        }

        public APIRequestGet requestTrackingParametersField() {
            return this.requestTrackingParametersField(true);
        }

        public APIRequestGet requestTrackingParametersField(boolean value) {
            this.requestField("tracking_parameters", value);
            return this;
        }
    }
}

