/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Profile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAtTextRange
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="length")
    private Long mLength = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="object")
    private Profile mObject = null;
    @SerializedName(value="offset")
    private Long mOffset = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static EntityAtTextRange loadJSON(String json, APIContext context, String header) {
        EntityAtTextRange entityAtTextRange = (EntityAtTextRange)EntityAtTextRange.getGson().fromJson(json, EntityAtTextRange.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(entityAtTextRange.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        entityAtTextRange.context = context;
        entityAtTextRange.rawValue = json;
        entityAtTextRange.header = header;
        return entityAtTextRange;
    }

    public static APINodeList<EntityAtTextRange> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<EntityAtTextRange> entityAtTextRanges = new APINodeList<EntityAtTextRange>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        entityAtTextRanges.add(EntityAtTextRange.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return entityAtTextRanges;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            entityAtTextRanges.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        entityAtTextRanges.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            entityAtTextRanges.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            entityAtTextRanges.add(EntityAtTextRange.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                entityAtTextRanges.add(EntityAtTextRange.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            entityAtTextRanges.add(EntityAtTextRange.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return entityAtTextRanges;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        entityAtTextRanges.add(EntityAtTextRange.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return entityAtTextRanges;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        entityAtTextRanges.add(EntityAtTextRange.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return entityAtTextRanges;
                }
                entityAtTextRanges.clear();
                entityAtTextRanges.add(EntityAtTextRange.loadJSON(json, context, header));
                return entityAtTextRanges;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return EntityAtTextRange.getGson().toJson((Object)this);
    }

    public String getFieldId() {
        return this.mId;
    }

    public EntityAtTextRange setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Long getFieldLength() {
        return this.mLength;
    }

    public EntityAtTextRange setFieldLength(Long value) {
        this.mLength = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public EntityAtTextRange setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Profile getFieldObject() {
        if (this.mObject != null) {
            this.mObject.context = this.getContext();
        }
        return this.mObject;
    }

    public EntityAtTextRange setFieldObject(Profile value) {
        this.mObject = value;
        return this;
    }

    public EntityAtTextRange setFieldObject(String value) {
        Type type = new TypeToken<Profile>(){}.getType();
        this.mObject = (Profile)Profile.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldOffset() {
        return this.mOffset;
    }

    public EntityAtTextRange setFieldOffset(Long value) {
        this.mOffset = value;
        return this;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public EntityAtTextRange setFieldType(EnumType value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public EntityAtTextRange copyFrom(EntityAtTextRange instance) {
        this.mId = instance.mId;
        this.mLength = instance.mLength;
        this.mName = instance.mName;
        this.mObject = instance.mObject;
        this.mOffset = instance.mOffset;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<EntityAtTextRange> getParser() {
        return new APIRequest.ResponseParser<EntityAtTextRange>(){

            @Override
            public APINodeList<EntityAtTextRange> parseResponse(String response, APIContext context, APIRequest<EntityAtTextRange> request, String header) throws APIException.MalformedResponseException {
                return EntityAtTextRange.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_APPLICATION("application"),
        VALUE_EVENT("event"),
        VALUE_GROUP("group"),
        VALUE_PAGE("page"),
        VALUE_USER("user"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

