/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenQualifier
extends APINode {
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="field_key")
    private String mFieldKey = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="label")
    private String mLabel = null;
    @SerializedName(value="question")
    private String mQuestion = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenQualifier loadJSON(String json, APIContext context, String header) {
        LeadGenQualifier leadGenQualifier = (LeadGenQualifier)LeadGenQualifier.getGson().fromJson(json, LeadGenQualifier.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenQualifier.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenQualifier.context = context;
        leadGenQualifier.rawValue = json;
        leadGenQualifier.header = header;
        return leadGenQualifier;
    }

    public static APINodeList<LeadGenQualifier> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenQualifier> leadGenQualifiers = new APINodeList<LeadGenQualifier>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenQualifiers.add(LeadGenQualifier.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return leadGenQualifiers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenQualifiers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenQualifiers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenQualifiers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenQualifiers.add(LeadGenQualifier.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenQualifiers.add(LeadGenQualifier.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenQualifiers.add(LeadGenQualifier.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return leadGenQualifiers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenQualifiers.add(LeadGenQualifier.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return leadGenQualifiers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenQualifiers.add(LeadGenQualifier.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenQualifiers;
                }
                leadGenQualifiers.clear();
                leadGenQualifiers.add(LeadGenQualifier.loadJSON(json, context, header));
                return leadGenQualifiers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenQualifier.getGson().toJson((Object)this);
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public LeadGenQualifier setFieldCategory(String value) {
        this.mCategory = value;
        return this;
    }

    public String getFieldFieldKey() {
        return this.mFieldKey;
    }

    public LeadGenQualifier setFieldFieldKey(String value) {
        this.mFieldKey = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public LeadGenQualifier setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldLabel() {
        return this.mLabel;
    }

    public LeadGenQualifier setFieldLabel(String value) {
        this.mLabel = value;
        return this;
    }

    public String getFieldQuestion() {
        return this.mQuestion;
    }

    public LeadGenQualifier setFieldQuestion(String value) {
        this.mQuestion = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenQualifier copyFrom(LeadGenQualifier instance) {
        this.mCategory = instance.mCategory;
        this.mFieldKey = instance.mFieldKey;
        this.mId = instance.mId;
        this.mLabel = instance.mLabel;
        this.mQuestion = instance.mQuestion;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenQualifier> getParser() {
        return new APIRequest.ResponseParser<LeadGenQualifier>(){

            @Override
            public APINodeList<LeadGenQualifier> parseResponse(String response, APIContext context, APIRequest<LeadGenQualifier> request, String header) throws APIException.MalformedResponseException {
                return LeadGenQualifier.parseResponse(response, context, request, header);
            }
        };
    }
}

