/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryCheckExtraInfo
extends APINode {
    @SerializedName(value="adgroup_ids")
    private List<String> mAdgroupIds = null;
    @SerializedName(value="campaign_ids")
    private List<String> mCampaignIds = null;
    @SerializedName(value="countries")
    private List<String> mCountries = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DeliveryCheckExtraInfo loadJSON(String json, APIContext context, String header) {
        DeliveryCheckExtraInfo deliveryCheckExtraInfo = (DeliveryCheckExtraInfo)DeliveryCheckExtraInfo.getGson().fromJson(json, DeliveryCheckExtraInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(deliveryCheckExtraInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        deliveryCheckExtraInfo.context = context;
        deliveryCheckExtraInfo.rawValue = json;
        deliveryCheckExtraInfo.header = header;
        return deliveryCheckExtraInfo;
    }

    public static APINodeList<DeliveryCheckExtraInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<DeliveryCheckExtraInfo> deliveryCheckExtraInfos = new APINodeList<DeliveryCheckExtraInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return deliveryCheckExtraInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            deliveryCheckExtraInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        deliveryCheckExtraInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            deliveryCheckExtraInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return deliveryCheckExtraInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return deliveryCheckExtraInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return deliveryCheckExtraInfos;
                }
                deliveryCheckExtraInfos.clear();
                deliveryCheckExtraInfos.add(DeliveryCheckExtraInfo.loadJSON(json, context, header));
                return deliveryCheckExtraInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DeliveryCheckExtraInfo.getGson().toJson((Object)this);
    }

    public List<String> getFieldAdgroupIds() {
        return this.mAdgroupIds;
    }

    public DeliveryCheckExtraInfo setFieldAdgroupIds(List<String> value) {
        this.mAdgroupIds = value;
        return this;
    }

    public List<String> getFieldCampaignIds() {
        return this.mCampaignIds;
    }

    public DeliveryCheckExtraInfo setFieldCampaignIds(List<String> value) {
        this.mCampaignIds = value;
        return this;
    }

    public List<String> getFieldCountries() {
        return this.mCountries;
    }

    public DeliveryCheckExtraInfo setFieldCountries(List<String> value) {
        this.mCountries = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public DeliveryCheckExtraInfo setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DeliveryCheckExtraInfo copyFrom(DeliveryCheckExtraInfo instance) {
        this.mAdgroupIds = instance.mAdgroupIds;
        this.mCampaignIds = instance.mCampaignIds;
        this.mCountries = instance.mCountries;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DeliveryCheckExtraInfo> getParser() {
        return new APIRequest.ResponseParser<DeliveryCheckExtraInfo>(){

            @Override
            public APINodeList<DeliveryCheckExtraInfo> parseResponse(String response, APIContext context, APIRequest<DeliveryCheckExtraInfo> request, String header) throws APIException.MalformedResponseException {
                return DeliveryCheckExtraInfo.parseResponse(response, context, request, header);
            }
        };
    }
}

