/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsActionStats
extends APINode {
    @SerializedName(value="1d_click")
    private String m1dClick = null;
    @SerializedName(value="1d_view")
    private String m1dView = null;
    @SerializedName(value="28d_click")
    private String m28dClick = null;
    @SerializedName(value="28d_view")
    private String m28dView = null;
    @SerializedName(value="7d_click")
    private String m7dClick = null;
    @SerializedName(value="7d_view")
    private String m7dView = null;
    @SerializedName(value="action_canvas_component_id")
    private String mActionCanvasComponentId = null;
    @SerializedName(value="action_canvas_component_name")
    private String mActionCanvasComponentName = null;
    @SerializedName(value="action_carousel_card_id")
    private String mActionCarouselCardId = null;
    @SerializedName(value="action_carousel_card_name")
    private String mActionCarouselCardName = null;
    @SerializedName(value="action_converted_product_id")
    private String mActionConvertedProductId = null;
    @SerializedName(value="action_destination")
    private String mActionDestination = null;
    @SerializedName(value="action_device")
    private String mActionDevice = null;
    @SerializedName(value="action_event_channel")
    private String mActionEventChannel = null;
    @SerializedName(value="action_link_click_destination")
    private String mActionLinkClickDestination = null;
    @SerializedName(value="action_location_code")
    private String mActionLocationCode = null;
    @SerializedName(value="action_reaction")
    private String mActionReaction = null;
    @SerializedName(value="action_target_id")
    private String mActionTargetId = null;
    @SerializedName(value="action_type")
    private String mActionType = null;
    @SerializedName(value="action_video_asset_id")
    private String mActionVideoAssetId = null;
    @SerializedName(value="action_video_sound")
    private String mActionVideoSound = null;
    @SerializedName(value="action_video_type")
    private String mActionVideoType = null;
    @SerializedName(value="inline")
    private String mInline = null;
    @SerializedName(value="value")
    private String mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsActionStats loadJSON(String json, APIContext context, String header) {
        AdsActionStats adsActionStats = (AdsActionStats)AdsActionStats.getGson().fromJson(json, AdsActionStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsActionStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsActionStats.context = context;
        adsActionStats.rawValue = json;
        adsActionStats.header = header;
        return adsActionStats;
    }

    public static APINodeList<AdsActionStats> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsActionStats> adsActionStatss = new APINodeList<AdsActionStats>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsActionStatss.add(AdsActionStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsActionStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsActionStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsActionStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsActionStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsActionStatss.add(AdsActionStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsActionStatss.add(AdsActionStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsActionStatss.add(AdsActionStats.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsActionStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsActionStatss.add(AdsActionStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsActionStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsActionStatss.add(AdsActionStats.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsActionStatss;
                }
                adsActionStatss.clear();
                adsActionStatss.add(AdsActionStats.loadJSON(json, context, header));
                return adsActionStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsActionStats.getGson().toJson((Object)this);
    }

    public String getField1dClick() {
        return this.m1dClick;
    }

    public AdsActionStats setField1dClick(String value) {
        this.m1dClick = value;
        return this;
    }

    public String getField1dView() {
        return this.m1dView;
    }

    public AdsActionStats setField1dView(String value) {
        this.m1dView = value;
        return this;
    }

    public String getField28dClick() {
        return this.m28dClick;
    }

    public AdsActionStats setField28dClick(String value) {
        this.m28dClick = value;
        return this;
    }

    public String getField28dView() {
        return this.m28dView;
    }

    public AdsActionStats setField28dView(String value) {
        this.m28dView = value;
        return this;
    }

    public String getField7dClick() {
        return this.m7dClick;
    }

    public AdsActionStats setField7dClick(String value) {
        this.m7dClick = value;
        return this;
    }

    public String getField7dView() {
        return this.m7dView;
    }

    public AdsActionStats setField7dView(String value) {
        this.m7dView = value;
        return this;
    }

    public String getFieldActionCanvasComponentId() {
        return this.mActionCanvasComponentId;
    }

    public AdsActionStats setFieldActionCanvasComponentId(String value) {
        this.mActionCanvasComponentId = value;
        return this;
    }

    public String getFieldActionCanvasComponentName() {
        return this.mActionCanvasComponentName;
    }

    public AdsActionStats setFieldActionCanvasComponentName(String value) {
        this.mActionCanvasComponentName = value;
        return this;
    }

    public String getFieldActionCarouselCardId() {
        return this.mActionCarouselCardId;
    }

    public AdsActionStats setFieldActionCarouselCardId(String value) {
        this.mActionCarouselCardId = value;
        return this;
    }

    public String getFieldActionCarouselCardName() {
        return this.mActionCarouselCardName;
    }

    public AdsActionStats setFieldActionCarouselCardName(String value) {
        this.mActionCarouselCardName = value;
        return this;
    }

    public String getFieldActionConvertedProductId() {
        return this.mActionConvertedProductId;
    }

    public AdsActionStats setFieldActionConvertedProductId(String value) {
        this.mActionConvertedProductId = value;
        return this;
    }

    public String getFieldActionDestination() {
        return this.mActionDestination;
    }

    public AdsActionStats setFieldActionDestination(String value) {
        this.mActionDestination = value;
        return this;
    }

    public String getFieldActionDevice() {
        return this.mActionDevice;
    }

    public AdsActionStats setFieldActionDevice(String value) {
        this.mActionDevice = value;
        return this;
    }

    public String getFieldActionEventChannel() {
        return this.mActionEventChannel;
    }

    public AdsActionStats setFieldActionEventChannel(String value) {
        this.mActionEventChannel = value;
        return this;
    }

    public String getFieldActionLinkClickDestination() {
        return this.mActionLinkClickDestination;
    }

    public AdsActionStats setFieldActionLinkClickDestination(String value) {
        this.mActionLinkClickDestination = value;
        return this;
    }

    public String getFieldActionLocationCode() {
        return this.mActionLocationCode;
    }

    public AdsActionStats setFieldActionLocationCode(String value) {
        this.mActionLocationCode = value;
        return this;
    }

    public String getFieldActionReaction() {
        return this.mActionReaction;
    }

    public AdsActionStats setFieldActionReaction(String value) {
        this.mActionReaction = value;
        return this;
    }

    public String getFieldActionTargetId() {
        return this.mActionTargetId;
    }

    public AdsActionStats setFieldActionTargetId(String value) {
        this.mActionTargetId = value;
        return this;
    }

    public String getFieldActionType() {
        return this.mActionType;
    }

    public AdsActionStats setFieldActionType(String value) {
        this.mActionType = value;
        return this;
    }

    public String getFieldActionVideoAssetId() {
        return this.mActionVideoAssetId;
    }

    public AdsActionStats setFieldActionVideoAssetId(String value) {
        this.mActionVideoAssetId = value;
        return this;
    }

    public String getFieldActionVideoSound() {
        return this.mActionVideoSound;
    }

    public AdsActionStats setFieldActionVideoSound(String value) {
        this.mActionVideoSound = value;
        return this;
    }

    public String getFieldActionVideoType() {
        return this.mActionVideoType;
    }

    public AdsActionStats setFieldActionVideoType(String value) {
        this.mActionVideoType = value;
        return this;
    }

    public String getFieldInline() {
        return this.mInline;
    }

    public AdsActionStats setFieldInline(String value) {
        this.mInline = value;
        return this;
    }

    public String getFieldValue() {
        return this.mValue;
    }

    public AdsActionStats setFieldValue(String value) {
        this.mValue = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdsActionStats setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsActionStats copyFrom(AdsActionStats instance) {
        this.m1dClick = instance.m1dClick;
        this.m1dView = instance.m1dView;
        this.m28dClick = instance.m28dClick;
        this.m28dView = instance.m28dView;
        this.m7dClick = instance.m7dClick;
        this.m7dView = instance.m7dView;
        this.mActionCanvasComponentId = instance.mActionCanvasComponentId;
        this.mActionCanvasComponentName = instance.mActionCanvasComponentName;
        this.mActionCarouselCardId = instance.mActionCarouselCardId;
        this.mActionCarouselCardName = instance.mActionCarouselCardName;
        this.mActionConvertedProductId = instance.mActionConvertedProductId;
        this.mActionDestination = instance.mActionDestination;
        this.mActionDevice = instance.mActionDevice;
        this.mActionEventChannel = instance.mActionEventChannel;
        this.mActionLinkClickDestination = instance.mActionLinkClickDestination;
        this.mActionLocationCode = instance.mActionLocationCode;
        this.mActionReaction = instance.mActionReaction;
        this.mActionTargetId = instance.mActionTargetId;
        this.mActionType = instance.mActionType;
        this.mActionVideoAssetId = instance.mActionVideoAssetId;
        this.mActionVideoSound = instance.mActionVideoSound;
        this.mActionVideoType = instance.mActionVideoType;
        this.mInline = instance.mInline;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsActionStats> getParser() {
        return new APIRequest.ResponseParser<AdsActionStats>(){

            @Override
            public APINodeList<AdsActionStats> parseResponse(String response, APIContext context, APIRequest<AdsActionStats> request, String header) throws APIException.MalformedResponseException {
                return AdsActionStats.parseResponse(response, context, request, header);
            }
        };
    }
}

