/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserNuxStatuses
extends APINode {
    @SerializedName(value="max_views")
    private Long mMaxViews = null;
    @SerializedName(value="nux_data")
    private Object mNuxData = null;
    @SerializedName(value="nux_id")
    private String mNuxId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserNuxStatuses loadJSON(String json, APIContext context, String header) {
        UserNuxStatuses userNuxStatuses = (UserNuxStatuses)UserNuxStatuses.getGson().fromJson(json, UserNuxStatuses.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userNuxStatuses.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userNuxStatuses.context = context;
        userNuxStatuses.rawValue = json;
        userNuxStatuses.header = header;
        return userNuxStatuses;
    }

    public static APINodeList<UserNuxStatuses> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserNuxStatuses> userNuxStatusess = new APINodeList<UserNuxStatuses>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return userNuxStatusess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userNuxStatusess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userNuxStatusess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userNuxStatusess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userNuxStatusess.add(UserNuxStatuses.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userNuxStatusess.add(UserNuxStatuses.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userNuxStatusess.add(UserNuxStatuses.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return userNuxStatusess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return userNuxStatusess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userNuxStatusess.add(UserNuxStatuses.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userNuxStatusess;
                }
                userNuxStatusess.clear();
                userNuxStatusess.add(UserNuxStatuses.loadJSON(json, context, header));
                return userNuxStatusess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserNuxStatuses.getGson().toJson((Object)this);
    }

    public Long getFieldMaxViews() {
        return this.mMaxViews;
    }

    public UserNuxStatuses setFieldMaxViews(Long value) {
        this.mMaxViews = value;
        return this;
    }

    public Object getFieldNuxData() {
        return this.mNuxData;
    }

    public UserNuxStatuses setFieldNuxData(Object value) {
        this.mNuxData = value;
        return this;
    }

    public String getFieldNuxId() {
        return this.mNuxId;
    }

    public UserNuxStatuses setFieldNuxId(String value) {
        this.mNuxId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public UserNuxStatuses setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserNuxStatuses copyFrom(UserNuxStatuses instance) {
        this.mMaxViews = instance.mMaxViews;
        this.mNuxData = instance.mNuxData;
        this.mNuxId = instance.mNuxId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserNuxStatuses> getParser() {
        return new APIRequest.ResponseParser<UserNuxStatuses>(){

            @Override
            public APINodeList<UserNuxStatuses> parseResponse(String response, APIContext context, APIRequest<UserNuxStatuses> request, String header) throws APIException.MalformedResponseException {
                return UserNuxStatuses.parseResponse(response, context, request, header);
            }
        };
    }
}

