/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ShadowIGMedia;
import com.facebook.ads.sdk.ShadowIGUser;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowIGComment
extends APINode {
    @SerializedName(value="hidden")
    private Boolean mHidden = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="like_count")
    private Long mLikeCount = null;
    @SerializedName(value="media")
    private ShadowIGMedia mMedia = null;
    @SerializedName(value="text")
    private String mText = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="user")
    private ShadowIGUser mUser = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    ShadowIGComment() {
    }

    public ShadowIGComment(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ShadowIGComment(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ShadowIGComment fetch() throws APIException {
        ShadowIGComment newInstance = ShadowIGComment.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ShadowIGComment fetchById(Long id, APIContext context) throws APIException {
        return ShadowIGComment.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ShadowIGComment> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ShadowIGComment.fetchByIdAsync(id.toString(), context);
    }

    public static ShadowIGComment fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ShadowIGComment> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ShadowIGComment> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ShadowIGComment>(context, "", "/", "GET", ShadowIGComment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ShadowIGComment>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ShadowIGComment>(context, "", "/", "GET", ShadowIGComment.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ShadowIGComment loadJSON(String json, APIContext context, String header) {
        ShadowIGComment shadowIGComment = (ShadowIGComment)ShadowIGComment.getGson().fromJson(json, ShadowIGComment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(shadowIGComment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        shadowIGComment.context = context;
        shadowIGComment.rawValue = json;
        shadowIGComment.header = header;
        return shadowIGComment;
    }

    public static APINodeList<ShadowIGComment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ShadowIGComment> shadowIGComments = new APINodeList<ShadowIGComment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        shadowIGComments.add(ShadowIGComment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return shadowIGComments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            shadowIGComments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        shadowIGComments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            shadowIGComments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            shadowIGComments.add(ShadowIGComment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                shadowIGComments.add(ShadowIGComment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            shadowIGComments.add(ShadowIGComment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return shadowIGComments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        shadowIGComments.add(ShadowIGComment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return shadowIGComments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        shadowIGComments.add(ShadowIGComment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return shadowIGComments;
                }
                shadowIGComments.clear();
                shadowIGComments.add(ShadowIGComment.loadJSON(json, context, header));
                return shadowIGComments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ShadowIGComment.getGson().toJson((Object)this);
    }

    public APIRequestGetReplies getReplies() {
        return new APIRequestGetReplies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateReply createReply() {
        return new APIRequestCreateReply(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldHidden() {
        return this.mHidden;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldLikeCount() {
        return this.mLikeCount;
    }

    public ShadowIGMedia getFieldMedia() {
        if (this.mMedia != null) {
            this.mMedia.context = this.getContext();
        }
        return this.mMedia;
    }

    public String getFieldText() {
        return this.mText;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public ShadowIGUser getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ShadowIGComment copyFrom(ShadowIGComment instance) {
        this.mHidden = instance.mHidden;
        this.mId = instance.mId;
        this.mLikeCount = instance.mLikeCount;
        this.mMedia = instance.mMedia;
        this.mText = instance.mText;
        this.mTimestamp = instance.mTimestamp;
        this.mUser = instance.mUser;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ShadowIGComment> getParser() {
        return new APIRequest.ResponseParser<ShadowIGComment>(){

            @Override
            public APINodeList<ShadowIGComment> parseResponse(String response, APIContext context, APIRequest<ShadowIGComment> request, String header) throws APIException.MalformedResponseException {
                return ShadowIGComment.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<ShadowIGComment> {
        ShadowIGComment lastResponse = null;
        public static final String[] PARAMS = new String[]{"hide"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ShadowIGComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGComment parseResponse(String response, String header) throws APIException {
            return ShadowIGComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ShadowIGComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGComment>(){

                public ShadowIGComment apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setHide(Boolean hide) {
            this.setParam("hide", hide);
            return this;
        }

        public APIRequestUpdate setHide(String hide) {
            this.setParam("hide", hide);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ShadowIGComment> {
        ShadowIGComment lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"hidden", "id", "like_count", "media", "text", "timestamp", "user", "username"};

        @Override
        public ShadowIGComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGComment parseResponse(String response, String header) throws APIException {
            return ShadowIGComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ShadowIGComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGComment>(){

                public ShadowIGComment apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestHiddenField() {
            return this.requestHiddenField(true);
        }

        public APIRequestGet requestHiddenField(boolean value) {
            this.requestField("hidden", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGet requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGet requestMediaField() {
            return this.requestMediaField(true);
        }

        public APIRequestGet requestMediaField(boolean value) {
            this.requestField("media", value);
            return this;
        }

        public APIRequestGet requestTextField() {
            return this.requestTextField(true);
        }

        public APIRequestGet requestTextField(boolean value) {
            this.requestField("text", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateReply
    extends APIRequest<ShadowIGComment> {
        ShadowIGComment lastResponse = null;
        public static final String[] PARAMS = new String[]{"message"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ShadowIGComment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGComment parseResponse(String response, String header) throws APIException {
            return ShadowIGComment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ShadowIGComment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGComment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGComment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGComment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGComment>(){

                public ShadowIGComment apply(String result) {
                    try {
                        return APIRequestCreateReply.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateReply(String nodeId, APIContext context) {
            super(context, nodeId, "/replies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateReply setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateReply setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateReply setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateReply requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateReply requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReply requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateReply requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateReply requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateReply requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReplies
    extends APIRequest<ShadowIGComment> {
        APINodeList<ShadowIGComment> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"hidden", "id", "like_count", "media", "text", "timestamp", "user", "username"};

        @Override
        public APINodeList<ShadowIGComment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ShadowIGComment> parseResponse(String response, String header) throws APIException {
            return ShadowIGComment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ShadowIGComment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ShadowIGComment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ShadowIGComment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ShadowIGComment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ShadowIGComment>>(){

                public APINodeList<ShadowIGComment> apply(String result) {
                    try {
                        return APIRequestGetReplies.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReplies(String nodeId, APIContext context) {
            super(context, nodeId, "/replies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReplies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReplies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReplies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReplies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReplies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReplies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReplies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReplies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReplies requestHiddenField() {
            return this.requestHiddenField(true);
        }

        public APIRequestGetReplies requestHiddenField(boolean value) {
            this.requestField("hidden", value);
            return this;
        }

        public APIRequestGetReplies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReplies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetReplies requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetReplies requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetReplies requestMediaField() {
            return this.requestMediaField(true);
        }

        public APIRequestGetReplies requestMediaField(boolean value) {
            this.requestField("media", value);
            return this;
        }

        public APIRequestGetReplies requestTextField() {
            return this.requestTextField(true);
        }

        public APIRequestGetReplies requestTextField(boolean value) {
            this.requestField("text", value);
            return this;
        }

        public APIRequestGetReplies requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetReplies requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGetReplies requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGetReplies requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }

        public APIRequestGetReplies requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetReplies requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }
}

