/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineTermsOfService
extends APINode {
    @SerializedName(value="accept_time")
    private Long mAcceptTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="signed_by_user")
    private User mSignedByUser = null;
    protected static Gson gson = null;

    OfflineTermsOfService() {
    }

    public OfflineTermsOfService(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OfflineTermsOfService(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OfflineTermsOfService fetch() throws APIException {
        OfflineTermsOfService newInstance = OfflineTermsOfService.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OfflineTermsOfService fetchById(Long id, APIContext context) throws APIException {
        return OfflineTermsOfService.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OfflineTermsOfService> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OfflineTermsOfService.fetchByIdAsync(id.toString(), context);
    }

    public static OfflineTermsOfService fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OfflineTermsOfService> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OfflineTermsOfService> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OfflineTermsOfService>(context, "", "/", "GET", OfflineTermsOfService.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OfflineTermsOfService>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OfflineTermsOfService>(context, "", "/", "GET", OfflineTermsOfService.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OfflineTermsOfService loadJSON(String json, APIContext context, String header) {
        OfflineTermsOfService offlineTermsOfService = (OfflineTermsOfService)OfflineTermsOfService.getGson().fromJson(json, OfflineTermsOfService.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(offlineTermsOfService.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        offlineTermsOfService.context = context;
        offlineTermsOfService.rawValue = json;
        offlineTermsOfService.header = header;
        return offlineTermsOfService;
    }

    public static APINodeList<OfflineTermsOfService> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OfflineTermsOfService> offlineTermsOfServices = new APINodeList<OfflineTermsOfService>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return offlineTermsOfServices;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            offlineTermsOfServices.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        offlineTermsOfServices.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            offlineTermsOfServices.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return offlineTermsOfServices;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return offlineTermsOfServices;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return offlineTermsOfServices;
                }
                offlineTermsOfServices.clear();
                offlineTermsOfServices.add(OfflineTermsOfService.loadJSON(json, context, header));
                return offlineTermsOfServices;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OfflineTermsOfService.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAcceptTime() {
        return this.mAcceptTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public User getFieldSignedByUser() {
        if (this.mSignedByUser != null) {
            this.mSignedByUser.context = this.getContext();
        }
        return this.mSignedByUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OfflineTermsOfService copyFrom(OfflineTermsOfService instance) {
        this.mAcceptTime = instance.mAcceptTime;
        this.mId = instance.mId;
        this.mSignedByUser = instance.mSignedByUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OfflineTermsOfService> getParser() {
        return new APIRequest.ResponseParser<OfflineTermsOfService>(){

            @Override
            public APINodeList<OfflineTermsOfService> parseResponse(String response, APIContext context, APIRequest<OfflineTermsOfService> request, String header) throws APIException.MalformedResponseException {
                return OfflineTermsOfService.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<OfflineTermsOfService> {
        OfflineTermsOfService lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"accept_time", "id", "signed_by_user"};

        @Override
        public OfflineTermsOfService getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OfflineTermsOfService parseResponse(String response, String header) throws APIException {
            return OfflineTermsOfService.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OfflineTermsOfService execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OfflineTermsOfService execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OfflineTermsOfService> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OfflineTermsOfService> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, OfflineTermsOfService>(){

                public OfflineTermsOfService apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAcceptTimeField() {
            return this.requestAcceptTimeField(true);
        }

        public APIRequestGet requestAcceptTimeField(boolean value) {
            this.requestField("accept_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestSignedByUserField() {
            return this.requestSignedByUserField(true);
        }

        public APIRequestGet requestSignedByUserField(boolean value) {
            this.requestField("signed_by_user", value);
            return this;
        }
    }
}

