/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LiveEncoder;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVideoInputStream
extends APINode {
    @SerializedName(value="dash_ingest_url")
    private String mDashIngestUrl = null;
    @SerializedName(value="dash_preview_url")
    private String mDashPreviewUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_master")
    private Boolean mIsMaster = null;
    @SerializedName(value="live_encoder")
    private LiveEncoder mLiveEncoder = null;
    @SerializedName(value="secure_stream_url")
    private String mSecureStreamUrl = null;
    @SerializedName(value="stream_health")
    private Object mStreamHealth = null;
    @SerializedName(value="stream_id")
    private String mStreamId = null;
    @SerializedName(value="stream_url")
    private String mStreamUrl = null;
    protected static Gson gson = null;

    LiveVideoInputStream() {
    }

    public LiveVideoInputStream(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LiveVideoInputStream(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LiveVideoInputStream fetch() throws APIException {
        LiveVideoInputStream newInstance = LiveVideoInputStream.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LiveVideoInputStream fetchById(Long id, APIContext context) throws APIException {
        return LiveVideoInputStream.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LiveVideoInputStream> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LiveVideoInputStream.fetchByIdAsync(id.toString(), context);
    }

    public static LiveVideoInputStream fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LiveVideoInputStream> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LiveVideoInputStream> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LiveVideoInputStream>(context, "", "/", "GET", LiveVideoInputStream.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LiveVideoInputStream>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LiveVideoInputStream>(context, "", "/", "GET", LiveVideoInputStream.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveVideoInputStream loadJSON(String json, APIContext context, String header) {
        LiveVideoInputStream liveVideoInputStream = (LiveVideoInputStream)LiveVideoInputStream.getGson().fromJson(json, LiveVideoInputStream.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveVideoInputStream.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveVideoInputStream.context = context;
        liveVideoInputStream.rawValue = json;
        liveVideoInputStream.header = header;
        return liveVideoInputStream;
    }

    public static APINodeList<LiveVideoInputStream> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveVideoInputStream> liveVideoInputStreams = new APINodeList<LiveVideoInputStream>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return liveVideoInputStreams;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveVideoInputStreams.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveVideoInputStreams.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveVideoInputStreams.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return liveVideoInputStreams;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return liveVideoInputStreams;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveVideoInputStreams;
                }
                liveVideoInputStreams.clear();
                liveVideoInputStreams.add(LiveVideoInputStream.loadJSON(json, context, header));
                return liveVideoInputStreams;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveVideoInputStream.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDashIngestUrl() {
        return this.mDashIngestUrl;
    }

    public String getFieldDashPreviewUrl() {
        return this.mDashPreviewUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsMaster() {
        return this.mIsMaster;
    }

    public LiveEncoder getFieldLiveEncoder() {
        if (this.mLiveEncoder != null) {
            this.mLiveEncoder.context = this.getContext();
        }
        return this.mLiveEncoder;
    }

    public String getFieldSecureStreamUrl() {
        return this.mSecureStreamUrl;
    }

    public Object getFieldStreamHealth() {
        return this.mStreamHealth;
    }

    public String getFieldStreamId() {
        return this.mStreamId;
    }

    public String getFieldStreamUrl() {
        return this.mStreamUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveVideoInputStream copyFrom(LiveVideoInputStream instance) {
        this.mDashIngestUrl = instance.mDashIngestUrl;
        this.mDashPreviewUrl = instance.mDashPreviewUrl;
        this.mId = instance.mId;
        this.mIsMaster = instance.mIsMaster;
        this.mLiveEncoder = instance.mLiveEncoder;
        this.mSecureStreamUrl = instance.mSecureStreamUrl;
        this.mStreamHealth = instance.mStreamHealth;
        this.mStreamId = instance.mStreamId;
        this.mStreamUrl = instance.mStreamUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveVideoInputStream> getParser() {
        return new APIRequest.ResponseParser<LiveVideoInputStream>(){

            @Override
            public APINodeList<LiveVideoInputStream> parseResponse(String response, APIContext context, APIRequest<LiveVideoInputStream> request, String header) throws APIException.MalformedResponseException {
                return LiveVideoInputStream.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LiveVideoInputStream> {
        LiveVideoInputStream lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"dash_ingest_url", "dash_preview_url", "id", "is_master", "live_encoder", "secure_stream_url", "stream_health", "stream_id", "stream_url"};

        @Override
        public LiveVideoInputStream getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveVideoInputStream parseResponse(String response, String header) throws APIException {
            return LiveVideoInputStream.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveVideoInputStream execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveVideoInputStream execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveVideoInputStream> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveVideoInputStream> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LiveVideoInputStream>(){

                public LiveVideoInputStream apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDashIngestUrlField() {
            return this.requestDashIngestUrlField(true);
        }

        public APIRequestGet requestDashIngestUrlField(boolean value) {
            this.requestField("dash_ingest_url", value);
            return this;
        }

        public APIRequestGet requestDashPreviewUrlField() {
            return this.requestDashPreviewUrlField(true);
        }

        public APIRequestGet requestDashPreviewUrlField(boolean value) {
            this.requestField("dash_preview_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsMasterField() {
            return this.requestIsMasterField(true);
        }

        public APIRequestGet requestIsMasterField(boolean value) {
            this.requestField("is_master", value);
            return this;
        }

        public APIRequestGet requestLiveEncoderField() {
            return this.requestLiveEncoderField(true);
        }

        public APIRequestGet requestLiveEncoderField(boolean value) {
            this.requestField("live_encoder", value);
            return this;
        }

        public APIRequestGet requestSecureStreamUrlField() {
            return this.requestSecureStreamUrlField(true);
        }

        public APIRequestGet requestSecureStreamUrlField(boolean value) {
            this.requestField("secure_stream_url", value);
            return this;
        }

        public APIRequestGet requestStreamHealthField() {
            return this.requestStreamHealthField(true);
        }

        public APIRequestGet requestStreamHealthField(boolean value) {
            this.requestField("stream_health", value);
            return this;
        }

        public APIRequestGet requestStreamIdField() {
            return this.requestStreamIdField(true);
        }

        public APIRequestGet requestStreamIdField(boolean value) {
            this.requestField("stream_id", value);
            return this;
        }

        public APIRequestGet requestStreamUrlField() {
            return this.requestStreamUrlField(true);
        }

        public APIRequestGet requestStreamUrlField(boolean value) {
            this.requestField("stream_url", value);
            return this;
        }
    }
}

