/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrandAudience
extends APINode {
    @SerializedName(value="account")
    private AdAccount mAccount = null;
    @SerializedName(value="delivery_targeting")
    private Targeting mDeliveryTargeting = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="sentence_lines")
    private JsonArray mSentenceLines = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="targeting")
    private Targeting mTargeting = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    BrandAudience() {
    }

    public BrandAudience(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BrandAudience(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BrandAudience fetch() throws APIException {
        BrandAudience newInstance = BrandAudience.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BrandAudience fetchById(Long id, APIContext context) throws APIException {
        return BrandAudience.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BrandAudience> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BrandAudience.fetchByIdAsync(id.toString(), context);
    }

    public static BrandAudience fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BrandAudience> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BrandAudience> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BrandAudience>(context, "", "/", "GET", BrandAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BrandAudience>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BrandAudience>(context, "", "/", "GET", BrandAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BrandAudience loadJSON(String json, APIContext context, String header) {
        BrandAudience brandAudience = (BrandAudience)BrandAudience.getGson().fromJson(json, BrandAudience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(brandAudience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        brandAudience.context = context;
        brandAudience.rawValue = json;
        brandAudience.header = header;
        return brandAudience;
    }

    public static APINodeList<BrandAudience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BrandAudience> brandAudiences = new APINodeList<BrandAudience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        brandAudiences.add(BrandAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return brandAudiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            brandAudiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        brandAudiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            brandAudiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            brandAudiences.add(BrandAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                brandAudiences.add(BrandAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            brandAudiences.add(BrandAudience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return brandAudiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        brandAudiences.add(BrandAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return brandAudiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        brandAudiences.add(BrandAudience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return brandAudiences;
                }
                brandAudiences.clear();
                brandAudiences.add(BrandAudience.loadJSON(json, context, header));
                return brandAudiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BrandAudience.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAccount() {
        if (this.mAccount != null) {
            this.mAccount.context = this.getContext();
        }
        return this.mAccount;
    }

    public Targeting getFieldDeliveryTargeting() {
        return this.mDeliveryTargeting;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public JsonArray getFieldSentenceLines() {
        return this.mSentenceLines;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Targeting getFieldTargeting() {
        return this.mTargeting;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BrandAudience copyFrom(BrandAudience instance) {
        this.mAccount = instance.mAccount;
        this.mDeliveryTargeting = instance.mDeliveryTargeting;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mSentenceLines = instance.mSentenceLines;
        this.mStatus = instance.mStatus;
        this.mTargeting = instance.mTargeting;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BrandAudience> getParser() {
        return new APIRequest.ResponseParser<BrandAudience>(){

            @Override
            public APINodeList<BrandAudience> parseResponse(String response, APIContext context, APIRequest<BrandAudience> request, String header) throws APIException.MalformedResponseException {
                return BrandAudience.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BrandAudience> {
        BrandAudience lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account", "delivery_targeting", "description", "id", "name", "sentence_lines", "status", "targeting", "time_created", "time_updated"};

        @Override
        public BrandAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BrandAudience parseResponse(String response, String header) throws APIException {
            return BrandAudience.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BrandAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BrandAudience execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BrandAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BrandAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BrandAudience>(){

                public BrandAudience apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountField() {
            return this.requestAccountField(true);
        }

        public APIRequestGet requestAccountField(boolean value) {
            this.requestField("account", value);
            return this;
        }

        public APIRequestGet requestDeliveryTargetingField() {
            return this.requestDeliveryTargetingField(true);
        }

        public APIRequestGet requestDeliveryTargetingField(boolean value) {
            this.requestField("delivery_targeting", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestSentenceLinesField() {
            return this.requestSentenceLinesField(true);
        }

        public APIRequestGet requestSentenceLinesField(boolean value) {
            this.requestField("sentence_lines", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGet requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }
}

