/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsQueryResult
extends APINode {
    @SerializedName(value="columns")
    private Object mColumns = null;
    @SerializedName(value="datapoints")
    private List<Object> mDatapoints = null;
    @SerializedName(value="error")
    private Object mError = null;
    @SerializedName(value="query_id")
    private String mQueryId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AnalyticsQueryResult loadJSON(String json, APIContext context, String header) {
        AnalyticsQueryResult analyticsQueryResult = (AnalyticsQueryResult)AnalyticsQueryResult.getGson().fromJson(json, AnalyticsQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsQueryResult.context = context;
        analyticsQueryResult.rawValue = json;
        analyticsQueryResult.header = header;
        return analyticsQueryResult;
    }

    public static APINodeList<AnalyticsQueryResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsQueryResult> analyticsQueryResults = new APINodeList<AnalyticsQueryResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return analyticsQueryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsQueryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsQueryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return analyticsQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return analyticsQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsQueryResults;
                }
                analyticsQueryResults.clear();
                analyticsQueryResults.add(AnalyticsQueryResult.loadJSON(json, context, header));
                return analyticsQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsQueryResult.getGson().toJson((Object)this);
    }

    public Object getFieldColumns() {
        return this.mColumns;
    }

    public AnalyticsQueryResult setFieldColumns(Object value) {
        this.mColumns = value;
        return this;
    }

    public List<Object> getFieldDatapoints() {
        return this.mDatapoints;
    }

    public AnalyticsQueryResult setFieldDatapoints(List<Object> value) {
        this.mDatapoints = value;
        return this;
    }

    public Object getFieldError() {
        return this.mError;
    }

    public AnalyticsQueryResult setFieldError(Object value) {
        this.mError = value;
        return this;
    }

    public String getFieldQueryId() {
        return this.mQueryId;
    }

    public AnalyticsQueryResult setFieldQueryId(String value) {
        this.mQueryId = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public AnalyticsQueryResult setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AnalyticsQueryResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsQueryResult copyFrom(AnalyticsQueryResult instance) {
        this.mColumns = instance.mColumns;
        this.mDatapoints = instance.mDatapoints;
        this.mError = instance.mError;
        this.mQueryId = instance.mQueryId;
        this.mStatus = instance.mStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsQueryResult> getParser() {
        return new APIRequest.ResponseParser<AnalyticsQueryResult>(){

            @Override
            public APINodeList<AnalyticsQueryResult> parseResponse(String response, APIContext context, APIRequest<AnalyticsQueryResult> request, String header) throws APIException.MalformedResponseException {
                return AnalyticsQueryResult.parseResponse(response, context, request, header);
            }
        };
    }
}

