/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsReportBuilder
extends APINode {
    @SerializedName(value="headers")
    private Object mHeaders = null;
    @SerializedName(value="rows")
    private List<Object> mRows = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsReportBuilder loadJSON(String json, APIContext context, String header) {
        AdsReportBuilder adsReportBuilder = (AdsReportBuilder)AdsReportBuilder.getGson().fromJson(json, AdsReportBuilder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsReportBuilder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsReportBuilder.context = context;
        adsReportBuilder.rawValue = json;
        adsReportBuilder.header = header;
        return adsReportBuilder;
    }

    public static APINodeList<AdsReportBuilder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsReportBuilder> adsReportBuilders = new APINodeList<AdsReportBuilder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsReportBuilders.add(AdsReportBuilder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsReportBuilders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsReportBuilders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsReportBuilders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsReportBuilders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsReportBuilders.add(AdsReportBuilder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsReportBuilders.add(AdsReportBuilder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsReportBuilders.add(AdsReportBuilder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsReportBuilders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsReportBuilders.add(AdsReportBuilder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsReportBuilders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsReportBuilders.add(AdsReportBuilder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsReportBuilders;
                }
                adsReportBuilders.clear();
                adsReportBuilders.add(AdsReportBuilder.loadJSON(json, context, header));
                return adsReportBuilders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsReportBuilder.getGson().toJson((Object)this);
    }

    public Object getFieldHeaders() {
        return this.mHeaders;
    }

    public AdsReportBuilder setFieldHeaders(Object value) {
        this.mHeaders = value;
        return this;
    }

    public List<Object> getFieldRows() {
        return this.mRows;
    }

    public AdsReportBuilder setFieldRows(List<Object> value) {
        this.mRows = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdsReportBuilder setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsReportBuilder copyFrom(AdsReportBuilder instance) {
        this.mHeaders = instance.mHeaders;
        this.mRows = instance.mRows;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsReportBuilder> getParser() {
        return new APIRequest.ResponseParser<AdsReportBuilder>(){

            @Override
            public APINodeList<AdsReportBuilder> parseResponse(String response, APIContext context, APIRequest<AdsReportBuilder> request, String header) throws APIException.MalformedResponseException {
                return AdsReportBuilder.parseResponse(response, context, request, header);
            }
        };
    }
}

