/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InsightsResult;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.Targeting;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPost
extends APINode {
    @SerializedName(value="admin_creator")
    private User mAdminCreator = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="feed_audience_description")
    private String mFeedAudienceDescription = null;
    @SerializedName(value="feed_targeting")
    private Targeting mFeedTargeting = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="og_action_summary")
    private String mOgActionSummary = null;
    @SerializedName(value="permalink_url")
    private String mPermalinkUrl = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="privacy_description")
    private String mPrivacyDescription = null;
    @SerializedName(value="promotion_info")
    private Object mPromotionInfo = null;
    @SerializedName(value="scheduled_publish_time")
    private String mScheduledPublishTime = null;
    @SerializedName(value="story_token")
    private String mStoryToken = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPost loadJSON(String json, APIContext context, String header) {
        AdsPost adsPost = (AdsPost)AdsPost.getGson().fromJson(json, AdsPost.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPost.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPost.context = context;
        adsPost.rawValue = json;
        adsPost.header = header;
        return adsPost;
    }

    public static APINodeList<AdsPost> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPost> adsPosts = new APINodeList<AdsPost>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPosts.add(AdsPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsPosts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPosts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPosts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPosts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPosts.add(AdsPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPosts.add(AdsPost.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPosts.add(AdsPost.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsPosts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPosts.add(AdsPost.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsPosts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPosts.add(AdsPost.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPosts;
                }
                adsPosts.clear();
                adsPosts.add(AdsPost.loadJSON(json, context, header));
                return adsPosts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPost.getGson().toJson((Object)this);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getId(), this.context);
    }

    public User getFieldAdminCreator() {
        if (this.mAdminCreator != null) {
            this.mAdminCreator.context = this.getContext();
        }
        return this.mAdminCreator;
    }

    public AdsPost setFieldAdminCreator(User value) {
        this.mAdminCreator = value;
        return this;
    }

    public AdsPost setFieldAdminCreator(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mAdminCreator = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public AdsPost setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldFeedAudienceDescription() {
        return this.mFeedAudienceDescription;
    }

    public AdsPost setFieldFeedAudienceDescription(String value) {
        this.mFeedAudienceDescription = value;
        return this;
    }

    public Targeting getFieldFeedTargeting() {
        return this.mFeedTargeting;
    }

    public AdsPost setFieldFeedTargeting(Targeting value) {
        this.mFeedTargeting = value;
        return this;
    }

    public AdsPost setFieldFeedTargeting(String value) {
        Type type = new TypeToken<Targeting>(){}.getType();
        this.mFeedTargeting = (Targeting)Targeting.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdsPost setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdsPost setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public AdsPost setFieldModifiedTime(String value) {
        this.mModifiedTime = value;
        return this;
    }

    public String getFieldOgActionSummary() {
        return this.mOgActionSummary;
    }

    public AdsPost setFieldOgActionSummary(String value) {
        this.mOgActionSummary = value;
        return this;
    }

    public String getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public AdsPost setFieldPermalinkUrl(String value) {
        this.mPermalinkUrl = value;
        return this;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public AdsPost setFieldPlace(Place value) {
        this.mPlace = value;
        return this;
    }

    public AdsPost setFieldPlace(String value) {
        Type type = new TypeToken<Place>(){}.getType();
        this.mPlace = (Place)Place.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPrivacyDescription() {
        return this.mPrivacyDescription;
    }

    public AdsPost setFieldPrivacyDescription(String value) {
        this.mPrivacyDescription = value;
        return this;
    }

    public Object getFieldPromotionInfo() {
        return this.mPromotionInfo;
    }

    public AdsPost setFieldPromotionInfo(Object value) {
        this.mPromotionInfo = value;
        return this;
    }

    public String getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public AdsPost setFieldScheduledPublishTime(String value) {
        this.mScheduledPublishTime = value;
        return this;
    }

    public String getFieldStoryToken() {
        return this.mStoryToken;
    }

    public AdsPost setFieldStoryToken(String value) {
        this.mStoryToken = value;
        return this;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public AdsPost setFieldThumbnail(String value) {
        this.mThumbnail = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public AdsPost setFieldType(String value) {
        this.mType = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public AdsPost setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPost copyFrom(AdsPost instance) {
        this.mAdminCreator = instance.mAdminCreator;
        this.mCreationTime = instance.mCreationTime;
        this.mFeedAudienceDescription = instance.mFeedAudienceDescription;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mId = instance.mId;
        this.mMessage = instance.mMessage;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOgActionSummary = instance.mOgActionSummary;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPlace = instance.mPlace;
        this.mPrivacyDescription = instance.mPrivacyDescription;
        this.mPromotionInfo = instance.mPromotionInfo;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mStoryToken = instance.mStoryToken;
        this.mThumbnail = instance.mThumbnail;
        this.mType = instance.mType;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPost> getParser() {
        return new APIRequest.ResponseParser<AdsPost>(){

            @Override
            public APINodeList<AdsPost> parseResponse(String response, APIContext context, APIRequest<AdsPost> request, String header) throws APIException.MalformedResponseException {
                return AdsPost.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<InsightsResult> {
        APINodeList<InsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "description_from_api_doc", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InsightsResult> parseResponse(String response, String header) throws APIException {
            return InsightsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<InsightsResult>>(){

                public APINodeList<InsightsResult> apply(String result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField() {
            return this.requestDescriptionFromApiDocField(true);
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField(boolean value) {
            this.requestField("description_from_api_doc", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }
}

