/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab
extends APINode {
    @SerializedName(value="application")
    private Application mApplication = null;
    @SerializedName(value="custom_image_url")
    private String mCustomImageUrl = null;
    @SerializedName(value="custom_name")
    private String mCustomName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="is_non_connection_landing_tab")
    private Boolean mIsNonConnectionLandingTab = null;
    @SerializedName(value="is_permanent")
    private Boolean mIsPermanent = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="position")
    private Long mPosition = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Tab loadJSON(String json, APIContext context) {
        Tab tab = (Tab)Tab.getGson().fromJson(json, Tab.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(tab.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        tab.context = context;
        tab.rawValue = json;
        return tab;
    }

    public static APINodeList<Tab> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Tab> tabs = new APINodeList<Tab>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        tabs.add(Tab.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return tabs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            tabs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        tabs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            tabs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            tabs.add(Tab.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                tabs.add(Tab.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            tabs.add(Tab.loadJSON(obj.toString(), context));
                        }
                    }
                    return tabs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        tabs.add(Tab.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return tabs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        tabs.add(Tab.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return tabs;
                }
                tabs.clear();
                tabs.add(Tab.loadJSON(json, context));
                return tabs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Tab.getGson().toJson((Object)this);
    }

    public Application getFieldApplication() {
        if (this.mApplication != null) {
            this.mApplication.context = this.getContext();
        }
        return this.mApplication;
    }

    public Tab setFieldApplication(Application value) {
        this.mApplication = value;
        return this;
    }

    public Tab setFieldApplication(String value) {
        Type type = new TypeToken<Application>(){}.getType();
        this.mApplication = (Application)Application.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCustomImageUrl() {
        return this.mCustomImageUrl;
    }

    public Tab setFieldCustomImageUrl(String value) {
        this.mCustomImageUrl = value;
        return this;
    }

    public String getFieldCustomName() {
        return this.mCustomName;
    }

    public Tab setFieldCustomName(String value) {
        this.mCustomName = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Tab setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public Tab setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public Boolean getFieldIsNonConnectionLandingTab() {
        return this.mIsNonConnectionLandingTab;
    }

    public Tab setFieldIsNonConnectionLandingTab(Boolean value) {
        this.mIsNonConnectionLandingTab = value;
        return this;
    }

    public Boolean getFieldIsPermanent() {
        return this.mIsPermanent;
    }

    public Tab setFieldIsPermanent(Boolean value) {
        this.mIsPermanent = value;
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public Tab setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Tab setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldPosition() {
        return this.mPosition;
    }

    public Tab setFieldPosition(Long value) {
        this.mPosition = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Tab copyFrom(Tab instance) {
        this.mApplication = instance.mApplication;
        this.mCustomImageUrl = instance.mCustomImageUrl;
        this.mCustomName = instance.mCustomName;
        this.mId = instance.mId;
        this.mImageUrl = instance.mImageUrl;
        this.mIsNonConnectionLandingTab = instance.mIsNonConnectionLandingTab;
        this.mIsPermanent = instance.mIsPermanent;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPosition = instance.mPosition;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Tab> getParser() {
        return new APIRequest.ResponseParser<Tab>(){

            @Override
            public APINodeList<Tab> parseResponse(String response, APIContext context, APIRequest<Tab> request) throws APIException.MalformedResponseException {
                return Tab.parseResponse(response, context, request);
            }
        };
    }
}

