/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LiveVideo;
import com.facebook.ads.sdk.LiveVideoInputStream;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveEncoder
extends APINode {
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="current_broadcast")
    private LiveVideo mCurrentBroadcast = null;
    @SerializedName(value="current_input_stream")
    private LiveVideoInputStream mCurrentInputStream = null;
    @SerializedName(value="device_id")
    private String mDeviceId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_heartbeat_time")
    private String mLastHeartbeatTime = null;
    @SerializedName(value="model")
    private String mModel = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="version")
    private String mVersion = null;
    protected static Gson gson = null;

    LiveEncoder() {
    }

    public LiveEncoder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LiveEncoder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LiveEncoder fetch() throws APIException {
        LiveEncoder newInstance = LiveEncoder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LiveEncoder fetchById(Long id, APIContext context) throws APIException {
        return LiveEncoder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LiveEncoder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LiveEncoder.fetchByIdAsync(id.toString(), context);
    }

    public static LiveEncoder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LiveEncoder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LiveEncoder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LiveEncoder>(context, "", "/", "GET", LiveEncoder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LiveEncoder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LiveEncoder>(context, "", "/", "GET", LiveEncoder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveEncoder loadJSON(String json, APIContext context) {
        LiveEncoder liveEncoder = (LiveEncoder)LiveEncoder.getGson().fromJson(json, LiveEncoder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveEncoder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveEncoder.context = context;
        liveEncoder.rawValue = json;
        return liveEncoder;
    }

    public static APINodeList<LiveEncoder> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveEncoder> liveEncoders = new APINodeList<LiveEncoder>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveEncoders.add(LiveEncoder.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return liveEncoders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveEncoders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveEncoders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveEncoders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveEncoders.add(LiveEncoder.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveEncoders.add(LiveEncoder.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveEncoders.add(LiveEncoder.loadJSON(obj.toString(), context));
                        }
                    }
                    return liveEncoders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveEncoders.add(LiveEncoder.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return liveEncoders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveEncoders.add(LiveEncoder.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveEncoders;
                }
                liveEncoders.clear();
                liveEncoders.add(LiveEncoder.loadJSON(json, context));
                return liveEncoders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveEncoder.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public LiveVideo getFieldCurrentBroadcast() {
        if (this.mCurrentBroadcast != null) {
            this.mCurrentBroadcast.context = this.getContext();
        }
        return this.mCurrentBroadcast;
    }

    public LiveVideoInputStream getFieldCurrentInputStream() {
        if (this.mCurrentInputStream != null) {
            this.mCurrentInputStream.context = this.getContext();
        }
        return this.mCurrentInputStream;
    }

    public String getFieldDeviceId() {
        return this.mDeviceId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastHeartbeatTime() {
        return this.mLastHeartbeatTime;
    }

    public String getFieldModel() {
        return this.mModel;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldVersion() {
        return this.mVersion;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveEncoder copyFrom(LiveEncoder instance) {
        this.mBrand = instance.mBrand;
        this.mCreationTime = instance.mCreationTime;
        this.mCurrentBroadcast = instance.mCurrentBroadcast;
        this.mCurrentInputStream = instance.mCurrentInputStream;
        this.mDeviceId = instance.mDeviceId;
        this.mId = instance.mId;
        this.mLastHeartbeatTime = instance.mLastHeartbeatTime;
        this.mModel = instance.mModel;
        this.mName = instance.mName;
        this.mStatus = instance.mStatus;
        this.mVersion = instance.mVersion;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveEncoder> getParser() {
        return new APIRequest.ResponseParser<LiveEncoder>(){

            @Override
            public APINodeList<LiveEncoder> parseResponse(String response, APIContext context, APIRequest<LiveEncoder> request) throws APIException.MalformedResponseException {
                return LiveEncoder.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LiveEncoder> {
        LiveEncoder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"brand", "creation_time", "current_broadcast", "current_input_stream", "device_id", "id", "last_heartbeat_time", "model", "name", "status", "version"};

        @Override
        public LiveEncoder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveEncoder parseResponse(String response) throws APIException {
            return LiveEncoder.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LiveEncoder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveEncoder execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LiveEncoder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveEncoder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LiveEncoder>(){

                public LiveEncoder apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCurrentBroadcastField() {
            return this.requestCurrentBroadcastField(true);
        }

        public APIRequestGet requestCurrentBroadcastField(boolean value) {
            this.requestField("current_broadcast", value);
            return this;
        }

        public APIRequestGet requestCurrentInputStreamField() {
            return this.requestCurrentInputStreamField(true);
        }

        public APIRequestGet requestCurrentInputStreamField(boolean value) {
            this.requestField("current_input_stream", value);
            return this;
        }

        public APIRequestGet requestDeviceIdField() {
            return this.requestDeviceIdField(true);
        }

        public APIRequestGet requestDeviceIdField(boolean value) {
            this.requestField("device_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastHeartbeatTimeField() {
            return this.requestLastHeartbeatTimeField(true);
        }

        public APIRequestGet requestLastHeartbeatTimeField(boolean value) {
            this.requestField("last_heartbeat_time", value);
            return this;
        }

        public APIRequestGet requestModelField() {
            return this.requestModelField(true);
        }

        public APIRequestGet requestModelField(boolean value) {
            this.requestField("model", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestVersionField() {
            return this.requestVersionField(true);
        }

        public APIRequestGet requestVersionField(boolean value) {
            this.requestField("version", value);
            return this;
        }
    }
}

