/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasAdSettings
extends APINode {
    @SerializedName(value="is_canvas_collection_eligible")
    private Boolean mIsCanvasCollectionEligible = null;
    @SerializedName(value="lead_form_created_time")
    private Object mLeadFormCreatedTime = null;
    @SerializedName(value="lead_form_name")
    private String mLeadFormName = null;
    @SerializedName(value="lead_gen_form_id")
    private String mLeadGenFormId = null;
    @SerializedName(value="leads_count")
    private Long mLeadsCount = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    @SerializedName(value="use_retailer_item_ids")
    private Boolean mUseRetailerItemIds = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CanvasAdSettings loadJSON(String json, APIContext context) {
        CanvasAdSettings canvasAdSettings = (CanvasAdSettings)CanvasAdSettings.getGson().fromJson(json, CanvasAdSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(canvasAdSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        canvasAdSettings.context = context;
        canvasAdSettings.rawValue = json;
        return canvasAdSettings;
    }

    public static APINodeList<CanvasAdSettings> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CanvasAdSettings> canvasAdSettingss = new APINodeList<CanvasAdSettings>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return canvasAdSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            canvasAdSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        canvasAdSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            canvasAdSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            canvasAdSettingss.add(CanvasAdSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                canvasAdSettingss.add(CanvasAdSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            canvasAdSettingss.add(CanvasAdSettings.loadJSON(obj.toString(), context));
                        }
                    }
                    return canvasAdSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return canvasAdSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return canvasAdSettingss;
                }
                canvasAdSettingss.clear();
                canvasAdSettingss.add(CanvasAdSettings.loadJSON(json, context));
                return canvasAdSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CanvasAdSettings.getGson().toJson((Object)this);
    }

    public Boolean getFieldIsCanvasCollectionEligible() {
        return this.mIsCanvasCollectionEligible;
    }

    public CanvasAdSettings setFieldIsCanvasCollectionEligible(Boolean value) {
        this.mIsCanvasCollectionEligible = value;
        return this;
    }

    public Object getFieldLeadFormCreatedTime() {
        return this.mLeadFormCreatedTime;
    }

    public CanvasAdSettings setFieldLeadFormCreatedTime(Object value) {
        this.mLeadFormCreatedTime = value;
        return this;
    }

    public String getFieldLeadFormName() {
        return this.mLeadFormName;
    }

    public CanvasAdSettings setFieldLeadFormName(String value) {
        this.mLeadFormName = value;
        return this;
    }

    public String getFieldLeadGenFormId() {
        return this.mLeadGenFormId;
    }

    public CanvasAdSettings setFieldLeadGenFormId(String value) {
        this.mLeadGenFormId = value;
        return this;
    }

    public Long getFieldLeadsCount() {
        return this.mLeadsCount;
    }

    public CanvasAdSettings setFieldLeadsCount(Long value) {
        this.mLeadsCount = value;
        return this;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public CanvasAdSettings setFieldProductSetId(String value) {
        this.mProductSetId = value;
        return this;
    }

    public Boolean getFieldUseRetailerItemIds() {
        return this.mUseRetailerItemIds;
    }

    public CanvasAdSettings setFieldUseRetailerItemIds(Boolean value) {
        this.mUseRetailerItemIds = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CanvasAdSettings setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CanvasAdSettings copyFrom(CanvasAdSettings instance) {
        this.mIsCanvasCollectionEligible = instance.mIsCanvasCollectionEligible;
        this.mLeadFormCreatedTime = instance.mLeadFormCreatedTime;
        this.mLeadFormName = instance.mLeadFormName;
        this.mLeadGenFormId = instance.mLeadGenFormId;
        this.mLeadsCount = instance.mLeadsCount;
        this.mProductSetId = instance.mProductSetId;
        this.mUseRetailerItemIds = instance.mUseRetailerItemIds;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CanvasAdSettings> getParser() {
        return new APIRequest.ResponseParser<CanvasAdSettings>(){

            @Override
            public APINodeList<CanvasAdSettings> parseResponse(String response, APIContext context, APIRequest<CanvasAdSettings> request) throws APIException.MalformedResponseException {
                return CanvasAdSettings.parseResponse(response, context, request);
            }
        };
    }
}

