/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessAdvertisableApplicationsResult
extends APINode {
    @SerializedName(value="has_insight_permission")
    private Boolean mHasInsightPermission = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="photo_url")
    private String mPhotoUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessAdvertisableApplicationsResult loadJSON(String json, APIContext context) {
        BusinessAdvertisableApplicationsResult businessAdvertisableApplicationsResult = (BusinessAdvertisableApplicationsResult)BusinessAdvertisableApplicationsResult.getGson().fromJson(json, BusinessAdvertisableApplicationsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessAdvertisableApplicationsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessAdvertisableApplicationsResult.context = context;
        businessAdvertisableApplicationsResult.rawValue = json;
        return businessAdvertisableApplicationsResult;
    }

    public static APINodeList<BusinessAdvertisableApplicationsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessAdvertisableApplicationsResult> businessAdvertisableApplicationsResults = new APINodeList<BusinessAdvertisableApplicationsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return businessAdvertisableApplicationsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessAdvertisableApplicationsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessAdvertisableApplicationsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessAdvertisableApplicationsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return businessAdvertisableApplicationsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return businessAdvertisableApplicationsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessAdvertisableApplicationsResults;
                }
                businessAdvertisableApplicationsResults.clear();
                businessAdvertisableApplicationsResults.add(BusinessAdvertisableApplicationsResult.loadJSON(json, context));
                return businessAdvertisableApplicationsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessAdvertisableApplicationsResult.getGson().toJson((Object)this);
    }

    public Boolean getFieldHasInsightPermission() {
        return this.mHasInsightPermission;
    }

    public BusinessAdvertisableApplicationsResult setFieldHasInsightPermission(Boolean value) {
        this.mHasInsightPermission = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public BusinessAdvertisableApplicationsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public BusinessAdvertisableApplicationsResult setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPhotoUrl() {
        return this.mPhotoUrl;
    }

    public BusinessAdvertisableApplicationsResult setFieldPhotoUrl(String value) {
        this.mPhotoUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessAdvertisableApplicationsResult copyFrom(BusinessAdvertisableApplicationsResult instance) {
        this.mHasInsightPermission = instance.mHasInsightPermission;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPhotoUrl = instance.mPhotoUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessAdvertisableApplicationsResult> getParser() {
        return new APIRequest.ResponseParser<BusinessAdvertisableApplicationsResult>(){

            @Override
            public APINodeList<BusinessAdvertisableApplicationsResult> parseResponse(String response, APIContext context, APIRequest<BusinessAdvertisableApplicationsResult> request) throws APIException.MalformedResponseException {
                return BusinessAdvertisableApplicationsResult.parseResponse(response, context, request);
            }
        };
    }
}

