/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimezoneOffset
extends APINode {
    @SerializedName(value="abbr")
    private String mAbbr = null;
    @SerializedName(value="isdst")
    private Boolean mIsdst = null;
    @SerializedName(value="offset")
    private Long mOffset = null;
    @SerializedName(value="time")
    private String mTime = null;
    @SerializedName(value="ts")
    private Long mTs = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TimezoneOffset loadJSON(String json, APIContext context, String header) {
        TimezoneOffset timezoneOffset = (TimezoneOffset)TimezoneOffset.getGson().fromJson(json, TimezoneOffset.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(timezoneOffset.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        timezoneOffset.context = context;
        timezoneOffset.rawValue = json;
        timezoneOffset.header = header;
        return timezoneOffset;
    }

    public static APINodeList<TimezoneOffset> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TimezoneOffset> timezoneOffsets = new APINodeList<TimezoneOffset>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return timezoneOffsets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            timezoneOffsets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        timezoneOffsets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            timezoneOffsets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            timezoneOffsets.add(TimezoneOffset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                timezoneOffsets.add(TimezoneOffset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            timezoneOffsets.add(TimezoneOffset.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return timezoneOffsets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return timezoneOffsets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        timezoneOffsets.add(TimezoneOffset.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return timezoneOffsets;
                }
                timezoneOffsets.clear();
                timezoneOffsets.add(TimezoneOffset.loadJSON(json, context, header));
                return timezoneOffsets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TimezoneOffset.getGson().toJson((Object)this);
    }

    public String getFieldAbbr() {
        return this.mAbbr;
    }

    public TimezoneOffset setFieldAbbr(String value) {
        this.mAbbr = value;
        return this;
    }

    public Boolean getFieldIsdst() {
        return this.mIsdst;
    }

    public TimezoneOffset setFieldIsdst(Boolean value) {
        this.mIsdst = value;
        return this;
    }

    public Long getFieldOffset() {
        return this.mOffset;
    }

    public TimezoneOffset setFieldOffset(Long value) {
        this.mOffset = value;
        return this;
    }

    public String getFieldTime() {
        return this.mTime;
    }

    public TimezoneOffset setFieldTime(String value) {
        this.mTime = value;
        return this;
    }

    public Long getFieldTs() {
        return this.mTs;
    }

    public TimezoneOffset setFieldTs(Long value) {
        this.mTs = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TimezoneOffset copyFrom(TimezoneOffset instance) {
        this.mAbbr = instance.mAbbr;
        this.mIsdst = instance.mIsdst;
        this.mOffset = instance.mOffset;
        this.mTime = instance.mTime;
        this.mTs = instance.mTs;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TimezoneOffset> getParser() {
        return new APIRequest.ResponseParser<TimezoneOffset>(){

            @Override
            public APINodeList<TimezoneOffset> parseResponse(String response, APIContext context, APIRequest<TimezoneOffset> request, String header) throws APIException.MalformedResponseException {
                return TimezoneOffset.parseResponse(response, context, request, header);
            }
        };
    }
}

