/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogCategory
extends APINode {
    @SerializedName(value="criteria_value")
    private String mCriteriaValue = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="destination_uri")
    private String mDestinationUri = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="num_items")
    private Long mNumItems = null;
    @SerializedName(value="tokens")
    private Map<String, String> mTokens = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductCatalogCategory loadJSON(String json, APIContext context, String header) {
        ProductCatalogCategory productCatalogCategory = (ProductCatalogCategory)ProductCatalogCategory.getGson().fromJson(json, ProductCatalogCategory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogCategory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogCategory.context = context;
        productCatalogCategory.rawValue = json;
        productCatalogCategory.header = header;
        return productCatalogCategory;
    }

    public static APINodeList<ProductCatalogCategory> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogCategory> productCatalogCategorys = new APINodeList<ProductCatalogCategory>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogCategorys.add(ProductCatalogCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productCatalogCategorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogCategorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogCategorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogCategorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogCategorys.add(ProductCatalogCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogCategorys.add(ProductCatalogCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogCategorys.add(ProductCatalogCategory.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productCatalogCategorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogCategorys.add(ProductCatalogCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productCatalogCategorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogCategorys.add(ProductCatalogCategory.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogCategorys;
                }
                productCatalogCategorys.clear();
                productCatalogCategorys.add(ProductCatalogCategory.loadJSON(json, context, header));
                return productCatalogCategorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogCategory.getGson().toJson((Object)this);
    }

    public String getFieldCriteriaValue() {
        return this.mCriteriaValue;
    }

    public ProductCatalogCategory setFieldCriteriaValue(String value) {
        this.mCriteriaValue = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public ProductCatalogCategory setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldDestinationUri() {
        return this.mDestinationUri;
    }

    public ProductCatalogCategory setFieldDestinationUri(String value) {
        this.mDestinationUri = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public ProductCatalogCategory setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public ProductCatalogCategory setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldNumItems() {
        return this.mNumItems;
    }

    public ProductCatalogCategory setFieldNumItems(Long value) {
        this.mNumItems = value;
        return this;
    }

    public Map<String, String> getFieldTokens() {
        return this.mTokens;
    }

    public ProductCatalogCategory setFieldTokens(Map<String, String> value) {
        this.mTokens = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogCategory copyFrom(ProductCatalogCategory instance) {
        this.mCriteriaValue = instance.mCriteriaValue;
        this.mDescription = instance.mDescription;
        this.mDestinationUri = instance.mDestinationUri;
        this.mImageUrl = instance.mImageUrl;
        this.mName = instance.mName;
        this.mNumItems = instance.mNumItems;
        this.mTokens = instance.mTokens;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogCategory> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogCategory>(){

            @Override
            public APINodeList<ProductCatalogCategory> parseResponse(String response, APIContext context, APIRequest<ProductCatalogCategory> request, String header) throws APIException.MalformedResponseException {
                return ProductCatalogCategory.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCategorizationCriteria {
        VALUE_BRAND("BRAND"),
        VALUE_CATEGORY("CATEGORY"),
        VALUE_PRODUCT_TYPE("PRODUCT_TYPE"),
        NULL(null);

        private String value;

        private EnumCategorizationCriteria(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

