/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessengerProfile
extends APINode {
    @SerializedName(value="account_linking_url")
    private String mAccountLinkingUrl = null;
    @SerializedName(value="get_started")
    private Object mGetStarted = null;
    @SerializedName(value="greeting")
    private List<Object> mGreeting = null;
    @SerializedName(value="home_url")
    private Object mHomeUrl = null;
    @SerializedName(value="payment_settings")
    private Object mPaymentSettings = null;
    @SerializedName(value="persistent_menu")
    private List<Object> mPersistentMenu = null;
    @SerializedName(value="target_audience")
    private Object mTargetAudience = null;
    @SerializedName(value="whitelisted_domains")
    private List<String> mWhitelistedDomains = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static MessengerProfile loadJSON(String json, APIContext context, String header) {
        MessengerProfile messengerProfile = (MessengerProfile)MessengerProfile.getGson().fromJson(json, MessengerProfile.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(messengerProfile.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        messengerProfile.context = context;
        messengerProfile.rawValue = json;
        messengerProfile.header = header;
        return messengerProfile;
    }

    public static APINodeList<MessengerProfile> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MessengerProfile> messengerProfiles = new APINodeList<MessengerProfile>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        messengerProfiles.add(MessengerProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return messengerProfiles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            messengerProfiles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        messengerProfiles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            messengerProfiles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            messengerProfiles.add(MessengerProfile.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                messengerProfiles.add(MessengerProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            messengerProfiles.add(MessengerProfile.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return messengerProfiles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        messengerProfiles.add(MessengerProfile.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return messengerProfiles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        messengerProfiles.add(MessengerProfile.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return messengerProfiles;
                }
                messengerProfiles.clear();
                messengerProfiles.add(MessengerProfile.loadJSON(json, context, header));
                return messengerProfiles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MessengerProfile.getGson().toJson((Object)this);
    }

    public String getFieldAccountLinkingUrl() {
        return this.mAccountLinkingUrl;
    }

    public MessengerProfile setFieldAccountLinkingUrl(String value) {
        this.mAccountLinkingUrl = value;
        return this;
    }

    public Object getFieldGetStarted() {
        return this.mGetStarted;
    }

    public MessengerProfile setFieldGetStarted(Object value) {
        this.mGetStarted = value;
        return this;
    }

    public List<Object> getFieldGreeting() {
        return this.mGreeting;
    }

    public MessengerProfile setFieldGreeting(List<Object> value) {
        this.mGreeting = value;
        return this;
    }

    public Object getFieldHomeUrl() {
        return this.mHomeUrl;
    }

    public MessengerProfile setFieldHomeUrl(Object value) {
        this.mHomeUrl = value;
        return this;
    }

    public Object getFieldPaymentSettings() {
        return this.mPaymentSettings;
    }

    public MessengerProfile setFieldPaymentSettings(Object value) {
        this.mPaymentSettings = value;
        return this;
    }

    public List<Object> getFieldPersistentMenu() {
        return this.mPersistentMenu;
    }

    public MessengerProfile setFieldPersistentMenu(List<Object> value) {
        this.mPersistentMenu = value;
        return this;
    }

    public Object getFieldTargetAudience() {
        return this.mTargetAudience;
    }

    public MessengerProfile setFieldTargetAudience(Object value) {
        this.mTargetAudience = value;
        return this;
    }

    public List<String> getFieldWhitelistedDomains() {
        return this.mWhitelistedDomains;
    }

    public MessengerProfile setFieldWhitelistedDomains(List<String> value) {
        this.mWhitelistedDomains = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MessengerProfile copyFrom(MessengerProfile instance) {
        this.mAccountLinkingUrl = instance.mAccountLinkingUrl;
        this.mGetStarted = instance.mGetStarted;
        this.mGreeting = instance.mGreeting;
        this.mHomeUrl = instance.mHomeUrl;
        this.mPaymentSettings = instance.mPaymentSettings;
        this.mPersistentMenu = instance.mPersistentMenu;
        this.mTargetAudience = instance.mTargetAudience;
        this.mWhitelistedDomains = instance.mWhitelistedDomains;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MessengerProfile> getParser() {
        return new APIRequest.ResponseParser<MessengerProfile>(){

            @Override
            public APINodeList<MessengerProfile> parseResponse(String response, APIContext context, APIRequest<MessengerProfile> request, String header) throws APIException.MalformedResponseException {
                return MessengerProfile.parseResponse(response, context, request, header);
            }
        };
    }
}

