/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitTestConfig
extends APINode {
    @SerializedName(value="budget")
    private Long mBudget = null;
    @SerializedName(value="early_winner_declaration_enabled")
    private Boolean mEarlyWinnerDeclarationEnabled = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="extend_winner_enabled")
    private Boolean mExtendWinnerEnabled = null;
    @SerializedName(value="splits")
    private List<Long> mSplits = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="test_variable")
    private String mTestVariable = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    SplitTestConfig() {
    }

    public SplitTestConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public SplitTestConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public SplitTestConfig fetch() throws APIException {
        SplitTestConfig newInstance = SplitTestConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static SplitTestConfig fetchById(Long id, APIContext context) throws APIException {
        return SplitTestConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<SplitTestConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return SplitTestConfig.fetchByIdAsync(id.toString(), context);
    }

    public static SplitTestConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<SplitTestConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<SplitTestConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<SplitTestConfig>(context, "", "/", "GET", SplitTestConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<SplitTestConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<SplitTestConfig>(context, "", "/", "GET", SplitTestConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static SplitTestConfig loadJSON(String json, APIContext context) {
        SplitTestConfig splitTestConfig = (SplitTestConfig)SplitTestConfig.getGson().fromJson(json, SplitTestConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(splitTestConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        splitTestConfig.context = context;
        splitTestConfig.rawValue = json;
        return splitTestConfig;
    }

    public static APINodeList<SplitTestConfig> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<SplitTestConfig> splitTestConfigs = new APINodeList<SplitTestConfig>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        splitTestConfigs.add(SplitTestConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return splitTestConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            splitTestConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        splitTestConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            splitTestConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            splitTestConfigs.add(SplitTestConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                splitTestConfigs.add(SplitTestConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            splitTestConfigs.add(SplitTestConfig.loadJSON(obj.toString(), context));
                        }
                    }
                    return splitTestConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        splitTestConfigs.add(SplitTestConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return splitTestConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        splitTestConfigs.add(SplitTestConfig.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return splitTestConfigs;
                }
                splitTestConfigs.clear();
                splitTestConfigs.add(SplitTestConfig.loadJSON(json, context));
                return splitTestConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return SplitTestConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldBudget() {
        return this.mBudget;
    }

    public Boolean getFieldEarlyWinnerDeclarationEnabled() {
        return this.mEarlyWinnerDeclarationEnabled;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Boolean getFieldExtendWinnerEnabled() {
        return this.mExtendWinnerEnabled;
    }

    public List<Long> getFieldSplits() {
        return this.mSplits;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldTestVariable() {
        return this.mTestVariable;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public SplitTestConfig copyFrom(SplitTestConfig instance) {
        this.mBudget = instance.mBudget;
        this.mEarlyWinnerDeclarationEnabled = instance.mEarlyWinnerDeclarationEnabled;
        this.mEndTime = instance.mEndTime;
        this.mExtendWinnerEnabled = instance.mExtendWinnerEnabled;
        this.mSplits = instance.mSplits;
        this.mStartTime = instance.mStartTime;
        this.mTestVariable = instance.mTestVariable;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<SplitTestConfig> getParser() {
        return new APIRequest.ResponseParser<SplitTestConfig>(){

            @Override
            public APINodeList<SplitTestConfig> parseResponse(String response, APIContext context, APIRequest<SplitTestConfig> request) throws APIException.MalformedResponseException {
                return SplitTestConfig.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<SplitTestConfig> {
        SplitTestConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"budget", "early_winner_declaration_enabled", "end_time", "extend_winner_enabled", "splits", "start_time", "test_variable", "id"};

        @Override
        public SplitTestConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public SplitTestConfig parseResponse(String response) throws APIException {
            return SplitTestConfig.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public SplitTestConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public SplitTestConfig execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<SplitTestConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<SplitTestConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, SplitTestConfig>(){

                public SplitTestConfig apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBudgetField() {
            return this.requestBudgetField(true);
        }

        public APIRequestGet requestBudgetField(boolean value) {
            this.requestField("budget", value);
            return this;
        }

        public APIRequestGet requestEarlyWinnerDeclarationEnabledField() {
            return this.requestEarlyWinnerDeclarationEnabledField(true);
        }

        public APIRequestGet requestEarlyWinnerDeclarationEnabledField(boolean value) {
            this.requestField("early_winner_declaration_enabled", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestExtendWinnerEnabledField() {
            return this.requestExtendWinnerEnabledField(true);
        }

        public APIRequestGet requestExtendWinnerEnabledField(boolean value) {
            this.requestField("extend_winner_enabled", value);
            return this;
        }

        public APIRequestGet requestSplitsField() {
            return this.requestSplitsField(true);
        }

        public APIRequestGet requestSplitsField(boolean value) {
            this.requestField("splits", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTestVariableField() {
            return this.requestTestVariableField(true);
        }

        public APIRequestGet requestTestVariableField(boolean value) {
            this.requestField("test_variable", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

