/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportStatsMetadata
extends APINode {
    @SerializedName(value="cutoff_date_account_data")
    private String mCutoffDateAccountData = null;
    @SerializedName(value="cutoff_date_actions")
    private String mCutoffDateActions = null;
    @SerializedName(value="cutoff_date_carousel_action_breakdown")
    private String mCutoffDateCarouselActionBreakdown = null;
    @SerializedName(value="cutoff_date_carousel_card_name")
    private String mCutoffDateCarouselCardName = null;
    @SerializedName(value="cutoff_date_demographics")
    private String mCutoffDateDemographics = null;
    @SerializedName(value="cutoff_date_general")
    private String mCutoffDateGeneral = null;
    @SerializedName(value="cutoff_date_placement")
    private String mCutoffDatePlacement = null;
    @SerializedName(value="cutoff_date_relevance_score")
    private String mCutoffDateRelevanceScore = null;
    @SerializedName(value="cutoff_date_video_type_breakdown")
    private String mCutoffDateVideoTypeBreakdown = null;
    @SerializedName(value="cutoff_date_website_ctr")
    private String mCutoffDateWebsiteCtr = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReportStatsMetadata loadJSON(String json, APIContext context) {
        ReportStatsMetadata reportStatsMetadata = (ReportStatsMetadata)ReportStatsMetadata.getGson().fromJson(json, ReportStatsMetadata.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reportStatsMetadata.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reportStatsMetadata.context = context;
        reportStatsMetadata.rawValue = json;
        return reportStatsMetadata;
    }

    public static APINodeList<ReportStatsMetadata> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReportStatsMetadata> reportStatsMetadatas = new APINodeList<ReportStatsMetadata>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reportStatsMetadatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reportStatsMetadatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reportStatsMetadatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reportStatsMetadatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(obj.toString(), context));
                        }
                    }
                    return reportStatsMetadatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reportStatsMetadatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reportStatsMetadatas;
                }
                reportStatsMetadatas.clear();
                reportStatsMetadatas.add(ReportStatsMetadata.loadJSON(json, context));
                return reportStatsMetadatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReportStatsMetadata.getGson().toJson((Object)this);
    }

    public String getFieldCutoffDateAccountData() {
        return this.mCutoffDateAccountData;
    }

    public ReportStatsMetadata setFieldCutoffDateAccountData(String value) {
        this.mCutoffDateAccountData = value;
        return this;
    }

    public String getFieldCutoffDateActions() {
        return this.mCutoffDateActions;
    }

    public ReportStatsMetadata setFieldCutoffDateActions(String value) {
        this.mCutoffDateActions = value;
        return this;
    }

    public String getFieldCutoffDateCarouselActionBreakdown() {
        return this.mCutoffDateCarouselActionBreakdown;
    }

    public ReportStatsMetadata setFieldCutoffDateCarouselActionBreakdown(String value) {
        this.mCutoffDateCarouselActionBreakdown = value;
        return this;
    }

    public String getFieldCutoffDateCarouselCardName() {
        return this.mCutoffDateCarouselCardName;
    }

    public ReportStatsMetadata setFieldCutoffDateCarouselCardName(String value) {
        this.mCutoffDateCarouselCardName = value;
        return this;
    }

    public String getFieldCutoffDateDemographics() {
        return this.mCutoffDateDemographics;
    }

    public ReportStatsMetadata setFieldCutoffDateDemographics(String value) {
        this.mCutoffDateDemographics = value;
        return this;
    }

    public String getFieldCutoffDateGeneral() {
        return this.mCutoffDateGeneral;
    }

    public ReportStatsMetadata setFieldCutoffDateGeneral(String value) {
        this.mCutoffDateGeneral = value;
        return this;
    }

    public String getFieldCutoffDatePlacement() {
        return this.mCutoffDatePlacement;
    }

    public ReportStatsMetadata setFieldCutoffDatePlacement(String value) {
        this.mCutoffDatePlacement = value;
        return this;
    }

    public String getFieldCutoffDateRelevanceScore() {
        return this.mCutoffDateRelevanceScore;
    }

    public ReportStatsMetadata setFieldCutoffDateRelevanceScore(String value) {
        this.mCutoffDateRelevanceScore = value;
        return this;
    }

    public String getFieldCutoffDateVideoTypeBreakdown() {
        return this.mCutoffDateVideoTypeBreakdown;
    }

    public ReportStatsMetadata setFieldCutoffDateVideoTypeBreakdown(String value) {
        this.mCutoffDateVideoTypeBreakdown = value;
        return this;
    }

    public String getFieldCutoffDateWebsiteCtr() {
        return this.mCutoffDateWebsiteCtr;
    }

    public ReportStatsMetadata setFieldCutoffDateWebsiteCtr(String value) {
        this.mCutoffDateWebsiteCtr = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ReportStatsMetadata setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReportStatsMetadata copyFrom(ReportStatsMetadata instance) {
        this.mCutoffDateAccountData = instance.mCutoffDateAccountData;
        this.mCutoffDateActions = instance.mCutoffDateActions;
        this.mCutoffDateCarouselActionBreakdown = instance.mCutoffDateCarouselActionBreakdown;
        this.mCutoffDateCarouselCardName = instance.mCutoffDateCarouselCardName;
        this.mCutoffDateDemographics = instance.mCutoffDateDemographics;
        this.mCutoffDateGeneral = instance.mCutoffDateGeneral;
        this.mCutoffDatePlacement = instance.mCutoffDatePlacement;
        this.mCutoffDateRelevanceScore = instance.mCutoffDateRelevanceScore;
        this.mCutoffDateVideoTypeBreakdown = instance.mCutoffDateVideoTypeBreakdown;
        this.mCutoffDateWebsiteCtr = instance.mCutoffDateWebsiteCtr;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReportStatsMetadata> getParser() {
        return new APIRequest.ResponseParser<ReportStatsMetadata>(){

            @Override
            public APINodeList<ReportStatsMetadata> parseResponse(String response, APIContext context, APIRequest<ReportStatsMetadata> request) throws APIException.MalformedResponseException {
                return ReportStatsMetadata.parseResponse(response, context, request);
            }
        };
    }
}

