/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Privacy
extends APINode {
    @SerializedName(value="allow")
    private Object mAllow = null;
    @SerializedName(value="deny")
    private Object mDeny = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="friends")
    private String mFriends = null;
    @SerializedName(value="networks")
    private String mNetworks = null;
    @SerializedName(value="value")
    private String mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Privacy loadJSON(String json, APIContext context) {
        Privacy privacy = (Privacy)Privacy.getGson().fromJson(json, Privacy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(privacy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        privacy.context = context;
        privacy.rawValue = json;
        return privacy;
    }

    public static APINodeList<Privacy> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Privacy> privacys = new APINodeList<Privacy>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        privacys.add(Privacy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return privacys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            privacys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        privacys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            privacys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            privacys.add(Privacy.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                privacys.add(Privacy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            privacys.add(Privacy.loadJSON(obj.toString(), context));
                        }
                    }
                    return privacys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        privacys.add(Privacy.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return privacys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        privacys.add(Privacy.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return privacys;
                }
                privacys.clear();
                privacys.add(Privacy.loadJSON(json, context));
                return privacys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Privacy.getGson().toJson((Object)this);
    }

    public Object getFieldAllow() {
        return this.mAllow;
    }

    public Privacy setFieldAllow(Object value) {
        this.mAllow = value;
        return this;
    }

    public Object getFieldDeny() {
        return this.mDeny;
    }

    public Privacy setFieldDeny(Object value) {
        this.mDeny = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Privacy setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldFriends() {
        return this.mFriends;
    }

    public Privacy setFieldFriends(String value) {
        this.mFriends = value;
        return this;
    }

    public String getFieldNetworks() {
        return this.mNetworks;
    }

    public Privacy setFieldNetworks(String value) {
        this.mNetworks = value;
        return this;
    }

    public String getFieldValue() {
        return this.mValue;
    }

    public Privacy setFieldValue(String value) {
        this.mValue = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Privacy setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Privacy copyFrom(Privacy instance) {
        this.mAllow = instance.mAllow;
        this.mDeny = instance.mDeny;
        this.mDescription = instance.mDescription;
        this.mFriends = instance.mFriends;
        this.mNetworks = instance.mNetworks;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Privacy> getParser() {
        return new APIRequest.ResponseParser<Privacy>(){

            @Override
            public APINodeList<Privacy> parseResponse(String response, APIContext context, APIRequest<Privacy> request) throws APIException.MalformedResponseException {
                return Privacy.parseResponse(response, context, request);
            }
        };
    }
}

