/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageStoreVisitsDemographicInsights
extends APINode {
    @SerializedName(value="breakdown")
    private String mBreakdown = null;
    @SerializedName(value="data_available_since")
    private String mDataAvailableSince = null;
    @SerializedName(value="data_available_until")
    private String mDataAvailableUntil = null;
    @SerializedName(value="values")
    private List<Object> mValues = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageStoreVisitsDemographicInsights loadJSON(String json, APIContext context) {
        PageStoreVisitsDemographicInsights pageStoreVisitsDemographicInsights = (PageStoreVisitsDemographicInsights)PageStoreVisitsDemographicInsights.getGson().fromJson(json, PageStoreVisitsDemographicInsights.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageStoreVisitsDemographicInsights.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageStoreVisitsDemographicInsights.context = context;
        pageStoreVisitsDemographicInsights.rawValue = json;
        return pageStoreVisitsDemographicInsights;
    }

    public static APINodeList<PageStoreVisitsDemographicInsights> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageStoreVisitsDemographicInsights> pageStoreVisitsDemographicInsightss = new APINodeList<PageStoreVisitsDemographicInsights>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageStoreVisitsDemographicInsightss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageStoreVisitsDemographicInsightss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageStoreVisitsDemographicInsightss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageStoreVisitsDemographicInsightss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageStoreVisitsDemographicInsightss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageStoreVisitsDemographicInsightss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageStoreVisitsDemographicInsightss;
                }
                pageStoreVisitsDemographicInsightss.clear();
                pageStoreVisitsDemographicInsightss.add(PageStoreVisitsDemographicInsights.loadJSON(json, context));
                return pageStoreVisitsDemographicInsightss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageStoreVisitsDemographicInsights.getGson().toJson((Object)this);
    }

    public String getFieldBreakdown() {
        return this.mBreakdown;
    }

    public PageStoreVisitsDemographicInsights setFieldBreakdown(String value) {
        this.mBreakdown = value;
        return this;
    }

    public String getFieldDataAvailableSince() {
        return this.mDataAvailableSince;
    }

    public PageStoreVisitsDemographicInsights setFieldDataAvailableSince(String value) {
        this.mDataAvailableSince = value;
        return this;
    }

    public String getFieldDataAvailableUntil() {
        return this.mDataAvailableUntil;
    }

    public PageStoreVisitsDemographicInsights setFieldDataAvailableUntil(String value) {
        this.mDataAvailableUntil = value;
        return this;
    }

    public List<Object> getFieldValues() {
        return this.mValues;
    }

    public PageStoreVisitsDemographicInsights setFieldValues(List<Object> value) {
        this.mValues = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PageStoreVisitsDemographicInsights setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageStoreVisitsDemographicInsights copyFrom(PageStoreVisitsDemographicInsights instance) {
        this.mBreakdown = instance.mBreakdown;
        this.mDataAvailableSince = instance.mDataAvailableSince;
        this.mDataAvailableUntil = instance.mDataAvailableUntil;
        this.mValues = instance.mValues;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageStoreVisitsDemographicInsights> getParser() {
        return new APIRequest.ResponseParser<PageStoreVisitsDemographicInsights>(){

            @Override
            public APINodeList<PageStoreVisitsDemographicInsights> parseResponse(String response, APIContext context, APIRequest<PageStoreVisitsDemographicInsights> request) throws APIException.MalformedResponseException {
                return PageStoreVisitsDemographicInsights.parseResponse(response, context, request);
            }
        };
    }
}

