/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.TextWithEntities;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMegaphone
extends APINode {
    @SerializedName(value="action")
    private Object mAction = null;
    @SerializedName(value="content")
    private TextWithEntities mContent = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image")
    private List<String> mImage = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static NativeMegaphone loadJSON(String json, APIContext context) {
        NativeMegaphone nativeMegaphone = (NativeMegaphone)NativeMegaphone.getGson().fromJson(json, NativeMegaphone.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(nativeMegaphone.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        nativeMegaphone.context = context;
        nativeMegaphone.rawValue = json;
        return nativeMegaphone;
    }

    public static APINodeList<NativeMegaphone> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<NativeMegaphone> nativeMegaphones = new APINodeList<NativeMegaphone>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        nativeMegaphones.add(NativeMegaphone.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return nativeMegaphones;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            nativeMegaphones.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        nativeMegaphones.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            nativeMegaphones.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            nativeMegaphones.add(NativeMegaphone.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                nativeMegaphones.add(NativeMegaphone.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            nativeMegaphones.add(NativeMegaphone.loadJSON(obj.toString(), context));
                        }
                    }
                    return nativeMegaphones;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        nativeMegaphones.add(NativeMegaphone.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return nativeMegaphones;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        nativeMegaphones.add(NativeMegaphone.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return nativeMegaphones;
                }
                nativeMegaphones.clear();
                nativeMegaphones.add(NativeMegaphone.loadJSON(json, context));
                return nativeMegaphones;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return NativeMegaphone.getGson().toJson((Object)this);
    }

    public Object getFieldAction() {
        return this.mAction;
    }

    public NativeMegaphone setFieldAction(Object value) {
        this.mAction = value;
        return this;
    }

    public TextWithEntities getFieldContent() {
        return this.mContent;
    }

    public NativeMegaphone setFieldContent(TextWithEntities value) {
        this.mContent = value;
        return this;
    }

    public NativeMegaphone setFieldContent(String value) {
        Type type = new TypeToken<TextWithEntities>(){}.getType();
        this.mContent = (TextWithEntities)TextWithEntities.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public NativeMegaphone setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public List<String> getFieldImage() {
        return this.mImage;
    }

    public NativeMegaphone setFieldImage(List<String> value) {
        this.mImage = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public NativeMegaphone setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public NativeMegaphone copyFrom(NativeMegaphone instance) {
        this.mAction = instance.mAction;
        this.mContent = instance.mContent;
        this.mId = instance.mId;
        this.mImage = instance.mImage;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<NativeMegaphone> getParser() {
        return new APIRequest.ResponseParser<NativeMegaphone>(){

            @Override
            public APINodeList<NativeMegaphone> parseResponse(String response, APIContext context, APIRequest<NativeMegaphone> request) throws APIException.MalformedResponseException {
                return NativeMegaphone.parseResponse(response, context, request);
            }
        };
    }
}

