/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncSession
extends APINode {
    @SerializedName(value="app")
    private Application mApp = null;
    @SerializedName(value="complete_time")
    private String mCompleteTime = null;
    @SerializedName(value="error_code")
    private Long mErrorCode = null;
    @SerializedName(value="exception")
    private String mException = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="method")
    private String mMethod = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="percent_completed")
    private Long mPercentCompleted = null;
    @SerializedName(value="platform_version")
    private String mPlatformVersion = null;
    @SerializedName(value="result")
    private String mResult = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="uri")
    private String mUri = null;
    @SerializedName(value="user")
    private User mUser = null;
    protected static Gson gson = null;

    AsyncSession() {
    }

    public AsyncSession(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AsyncSession(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AsyncSession fetch() throws APIException {
        AsyncSession newInstance = AsyncSession.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AsyncSession fetchById(Long id, APIContext context) throws APIException {
        return AsyncSession.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AsyncSession> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AsyncSession.fetchByIdAsync(id.toString(), context);
    }

    public static AsyncSession fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AsyncSession> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AsyncSession> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AsyncSession>(context, "", "/", "GET", AsyncSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AsyncSession>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AsyncSession>(context, "", "/", "GET", AsyncSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AsyncSession loadJSON(String json, APIContext context) {
        AsyncSession asyncSession = (AsyncSession)AsyncSession.getGson().fromJson(json, AsyncSession.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(asyncSession.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        asyncSession.context = context;
        asyncSession.rawValue = json;
        return asyncSession;
    }

    public static APINodeList<AsyncSession> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AsyncSession> asyncSessions = new APINodeList<AsyncSession>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        asyncSessions.add(AsyncSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return asyncSessions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            asyncSessions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        asyncSessions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            asyncSessions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            asyncSessions.add(AsyncSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                asyncSessions.add(AsyncSession.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            asyncSessions.add(AsyncSession.loadJSON(obj.toString(), context));
                        }
                    }
                    return asyncSessions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        asyncSessions.add(AsyncSession.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return asyncSessions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        asyncSessions.add(AsyncSession.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return asyncSessions;
                }
                asyncSessions.clear();
                asyncSessions.add(AsyncSession.loadJSON(json, context));
                return asyncSessions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AsyncSession.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Application getFieldApp() {
        if (this.mApp != null) {
            this.mApp.context = this.getContext();
        }
        return this.mApp;
    }

    public String getFieldCompleteTime() {
        return this.mCompleteTime;
    }

    public Long getFieldErrorCode() {
        return this.mErrorCode;
    }

    public String getFieldException() {
        return this.mException;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMethod() {
        return this.mMethod;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public Long getFieldPercentCompleted() {
        return this.mPercentCompleted;
    }

    public String getFieldPlatformVersion() {
        return this.mPlatformVersion;
    }

    public String getFieldResult() {
        return this.mResult;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldUri() {
        return this.mUri;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AsyncSession copyFrom(AsyncSession instance) {
        this.mApp = instance.mApp;
        this.mCompleteTime = instance.mCompleteTime;
        this.mErrorCode = instance.mErrorCode;
        this.mException = instance.mException;
        this.mId = instance.mId;
        this.mMethod = instance.mMethod;
        this.mName = instance.mName;
        this.mPage = instance.mPage;
        this.mPercentCompleted = instance.mPercentCompleted;
        this.mPlatformVersion = instance.mPlatformVersion;
        this.mResult = instance.mResult;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mUri = instance.mUri;
        this.mUser = instance.mUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AsyncSession> getParser() {
        return new APIRequest.ResponseParser<AsyncSession>(){

            @Override
            public APINodeList<AsyncSession> parseResponse(String response, APIContext context, APIRequest<AsyncSession> request) throws APIException.MalformedResponseException {
                return AsyncSession.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AsyncSession> {
        AsyncSession lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"app", "complete_time", "error_code", "exception", "id", "method", "name", "page", "percent_completed", "platform_version", "result", "start_time", "status", "uri", "user"};

        @Override
        public AsyncSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AsyncSession parseResponse(String response) throws APIException {
            return AsyncSession.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AsyncSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AsyncSession execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AsyncSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AsyncSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AsyncSession>(){

                public AsyncSession apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGet requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGet requestCompleteTimeField() {
            return this.requestCompleteTimeField(true);
        }

        public APIRequestGet requestCompleteTimeField(boolean value) {
            this.requestField("complete_time", value);
            return this;
        }

        public APIRequestGet requestErrorCodeField() {
            return this.requestErrorCodeField(true);
        }

        public APIRequestGet requestErrorCodeField(boolean value) {
            this.requestField("error_code", value);
            return this;
        }

        public APIRequestGet requestExceptionField() {
            return this.requestExceptionField(true);
        }

        public APIRequestGet requestExceptionField(boolean value) {
            this.requestField("exception", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMethodField() {
            return this.requestMethodField(true);
        }

        public APIRequestGet requestMethodField(boolean value) {
            this.requestField("method", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestPercentCompletedField() {
            return this.requestPercentCompletedField(true);
        }

        public APIRequestGet requestPercentCompletedField(boolean value) {
            this.requestField("percent_completed", value);
            return this;
        }

        public APIRequestGet requestPlatformVersionField() {
            return this.requestPlatformVersionField(true);
        }

        public APIRequestGet requestPlatformVersionField(boolean value) {
            this.requestField("platform_version", value);
            return this;
        }

        public APIRequestGet requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGet requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUriField() {
            return this.requestUriField(true);
        }

        public APIRequestGet requestUriField(boolean value) {
            this.requestField("uri", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }
}

